// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.SharedWithChannelTeamInfo;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Shared With Channel Team Info Request Builder.
 */
public class SharedWithChannelTeamInfoRequestBuilder extends BaseRequestBuilder<SharedWithChannelTeamInfo> {

    /**
     * The request builder for the SharedWithChannelTeamInfo
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SharedWithChannelTeamInfoRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the SharedWithChannelTeamInfoRequest instance
     */
    @Nonnull
    public SharedWithChannelTeamInfoRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the SharedWithChannelTeamInfoRequest instance
     */
    @Nonnull
    public SharedWithChannelTeamInfoRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.SharedWithChannelTeamInfoRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for Team
     *
     * @return the TeamWithReferenceRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.TeamWithReferenceRequestBuilder team() {
        return new com.microsoft.graph.requests.TeamWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("team"), getClient(), null);
    }
    /**
     *  Gets a request builder for the ConversationMember collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.ConversationMemberCollectionWithReferencesRequestBuilder allowedMembers() {
        return new com.microsoft.graph.requests.ConversationMemberCollectionWithReferencesRequestBuilder(getRequestUrlWithAdditionalSegment("allowedMembers"), getClient(), null);
    }

    /**
     * Gets a request builder for the ConversationMember item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.ConversationMemberWithReferenceRequestBuilder allowedMembers(@Nonnull final String id) {
        return new com.microsoft.graph.requests.ConversationMemberWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("allowedMembers") + "/" + id, getClient(), null);
    }
}
