// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.PasswordAuthenticationMethod;
import com.microsoft.graph.models.PasswordResetResponse;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Password Authentication Method Request.
 */
public class PasswordAuthenticationMethodRequest extends BaseRequest<PasswordAuthenticationMethod> {
	
    /**
     * The request for the PasswordAuthenticationMethod
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PasswordAuthenticationMethodRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PasswordAuthenticationMethod.class);
    }

    /**
     * Gets the PasswordAuthenticationMethod from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PasswordAuthenticationMethod> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the PasswordAuthenticationMethod from the service
     *
     * @return the PasswordAuthenticationMethod from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PasswordAuthenticationMethod get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PasswordAuthenticationMethod> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public PasswordAuthenticationMethod delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this PasswordAuthenticationMethod with a source
     *
     * @param sourcePasswordAuthenticationMethod the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PasswordAuthenticationMethod> patchAsync(@Nonnull final PasswordAuthenticationMethod sourcePasswordAuthenticationMethod) {
        return sendAsync(HttpMethod.PATCH, sourcePasswordAuthenticationMethod);
    }

    /**
     * Patches this PasswordAuthenticationMethod with a source
     *
     * @param sourcePasswordAuthenticationMethod the source object with updates
     * @return the updated PasswordAuthenticationMethod
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PasswordAuthenticationMethod patch(@Nonnull final PasswordAuthenticationMethod sourcePasswordAuthenticationMethod) throws ClientException {
        return send(HttpMethod.PATCH, sourcePasswordAuthenticationMethod);
    }

    /**
     * Creates a PasswordAuthenticationMethod with a new object
     *
     * @param newPasswordAuthenticationMethod the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PasswordAuthenticationMethod> postAsync(@Nonnull final PasswordAuthenticationMethod newPasswordAuthenticationMethod) {
        return sendAsync(HttpMethod.POST, newPasswordAuthenticationMethod);
    }

    /**
     * Creates a PasswordAuthenticationMethod with a new object
     *
     * @param newPasswordAuthenticationMethod the new object to create
     * @return the created PasswordAuthenticationMethod
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PasswordAuthenticationMethod post(@Nonnull final PasswordAuthenticationMethod newPasswordAuthenticationMethod) throws ClientException {
        return send(HttpMethod.POST, newPasswordAuthenticationMethod);
    }

    /**
     * Creates a PasswordAuthenticationMethod with a new object
     *
     * @param newPasswordAuthenticationMethod the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PasswordAuthenticationMethod> putAsync(@Nonnull final PasswordAuthenticationMethod newPasswordAuthenticationMethod) {
        return sendAsync(HttpMethod.PUT, newPasswordAuthenticationMethod);
    }

    /**
     * Creates a PasswordAuthenticationMethod with a new object
     *
     * @param newPasswordAuthenticationMethod the object to create/update
     * @return the created PasswordAuthenticationMethod
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PasswordAuthenticationMethod put(@Nonnull final PasswordAuthenticationMethod newPasswordAuthenticationMethod) throws ClientException {
        return send(HttpMethod.PUT, newPasswordAuthenticationMethod);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public PasswordAuthenticationMethodRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public PasswordAuthenticationMethodRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

