// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.OutlookItem;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Outlook Item Request.
 */
public class OutlookItemRequest extends BaseRequest<OutlookItem> {
	
    /**
     * The request for the OutlookItem
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public OutlookItemRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends OutlookItem> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the OutlookItem
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OutlookItemRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, OutlookItem.class);
    }

    /**
     * Gets the OutlookItem from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OutlookItem> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the OutlookItem from the service
     *
     * @return the OutlookItem from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OutlookItem get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OutlookItem> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public OutlookItem delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this OutlookItem with a source
     *
     * @param sourceOutlookItem the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OutlookItem> patchAsync(@Nonnull final OutlookItem sourceOutlookItem) {
        return sendAsync(HttpMethod.PATCH, sourceOutlookItem);
    }

    /**
     * Patches this OutlookItem with a source
     *
     * @param sourceOutlookItem the source object with updates
     * @return the updated OutlookItem
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OutlookItem patch(@Nonnull final OutlookItem sourceOutlookItem) throws ClientException {
        return send(HttpMethod.PATCH, sourceOutlookItem);
    }

    /**
     * Creates a OutlookItem with a new object
     *
     * @param newOutlookItem the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OutlookItem> postAsync(@Nonnull final OutlookItem newOutlookItem) {
        return sendAsync(HttpMethod.POST, newOutlookItem);
    }

    /**
     * Creates a OutlookItem with a new object
     *
     * @param newOutlookItem the new object to create
     * @return the created OutlookItem
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OutlookItem post(@Nonnull final OutlookItem newOutlookItem) throws ClientException {
        return send(HttpMethod.POST, newOutlookItem);
    }

    /**
     * Creates a OutlookItem with a new object
     *
     * @param newOutlookItem the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OutlookItem> putAsync(@Nonnull final OutlookItem newOutlookItem) {
        return sendAsync(HttpMethod.PUT, newOutlookItem);
    }

    /**
     * Creates a OutlookItem with a new object
     *
     * @param newOutlookItem the object to create/update
     * @return the created OutlookItem
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OutlookItem put(@Nonnull final OutlookItem newOutlookItem) throws ClientException {
        return send(HttpMethod.PUT, newOutlookItem);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public OutlookItemRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public OutlookItemRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

