// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.MalwareStateForWindowsDevice;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Malware State For Windows Device Request.
 */
public class MalwareStateForWindowsDeviceRequest extends BaseRequest<MalwareStateForWindowsDevice> {
	
    /**
     * The request for the MalwareStateForWindowsDevice
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MalwareStateForWindowsDeviceRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, MalwareStateForWindowsDevice.class);
    }

    /**
     * Gets the MalwareStateForWindowsDevice from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MalwareStateForWindowsDevice> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the MalwareStateForWindowsDevice from the service
     *
     * @return the MalwareStateForWindowsDevice from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MalwareStateForWindowsDevice get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MalwareStateForWindowsDevice> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public MalwareStateForWindowsDevice delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this MalwareStateForWindowsDevice with a source
     *
     * @param sourceMalwareStateForWindowsDevice the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MalwareStateForWindowsDevice> patchAsync(@Nonnull final MalwareStateForWindowsDevice sourceMalwareStateForWindowsDevice) {
        return sendAsync(HttpMethod.PATCH, sourceMalwareStateForWindowsDevice);
    }

    /**
     * Patches this MalwareStateForWindowsDevice with a source
     *
     * @param sourceMalwareStateForWindowsDevice the source object with updates
     * @return the updated MalwareStateForWindowsDevice
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MalwareStateForWindowsDevice patch(@Nonnull final MalwareStateForWindowsDevice sourceMalwareStateForWindowsDevice) throws ClientException {
        return send(HttpMethod.PATCH, sourceMalwareStateForWindowsDevice);
    }

    /**
     * Creates a MalwareStateForWindowsDevice with a new object
     *
     * @param newMalwareStateForWindowsDevice the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MalwareStateForWindowsDevice> postAsync(@Nonnull final MalwareStateForWindowsDevice newMalwareStateForWindowsDevice) {
        return sendAsync(HttpMethod.POST, newMalwareStateForWindowsDevice);
    }

    /**
     * Creates a MalwareStateForWindowsDevice with a new object
     *
     * @param newMalwareStateForWindowsDevice the new object to create
     * @return the created MalwareStateForWindowsDevice
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MalwareStateForWindowsDevice post(@Nonnull final MalwareStateForWindowsDevice newMalwareStateForWindowsDevice) throws ClientException {
        return send(HttpMethod.POST, newMalwareStateForWindowsDevice);
    }

    /**
     * Creates a MalwareStateForWindowsDevice with a new object
     *
     * @param newMalwareStateForWindowsDevice the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MalwareStateForWindowsDevice> putAsync(@Nonnull final MalwareStateForWindowsDevice newMalwareStateForWindowsDevice) {
        return sendAsync(HttpMethod.PUT, newMalwareStateForWindowsDevice);
    }

    /**
     * Creates a MalwareStateForWindowsDevice with a new object
     *
     * @param newMalwareStateForWindowsDevice the object to create/update
     * @return the created MalwareStateForWindowsDevice
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MalwareStateForWindowsDevice put(@Nonnull final MalwareStateForWindowsDevice newMalwareStateForWindowsDevice) throws ClientException {
        return send(HttpMethod.PUT, newMalwareStateForWindowsDevice);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public MalwareStateForWindowsDeviceRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public MalwareStateForWindowsDeviceRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

