// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.LongRunningOperation;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Long Running Operation Request.
 */
public class LongRunningOperationRequest extends BaseRequest<LongRunningOperation> {
	
    /**
     * The request for the LongRunningOperation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public LongRunningOperationRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends LongRunningOperation> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the LongRunningOperation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public LongRunningOperationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, LongRunningOperation.class);
    }

    /**
     * Gets the LongRunningOperation from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LongRunningOperation> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the LongRunningOperation from the service
     *
     * @return the LongRunningOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LongRunningOperation get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LongRunningOperation> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public LongRunningOperation delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this LongRunningOperation with a source
     *
     * @param sourceLongRunningOperation the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LongRunningOperation> patchAsync(@Nonnull final LongRunningOperation sourceLongRunningOperation) {
        return sendAsync(HttpMethod.PATCH, sourceLongRunningOperation);
    }

    /**
     * Patches this LongRunningOperation with a source
     *
     * @param sourceLongRunningOperation the source object with updates
     * @return the updated LongRunningOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LongRunningOperation patch(@Nonnull final LongRunningOperation sourceLongRunningOperation) throws ClientException {
        return send(HttpMethod.PATCH, sourceLongRunningOperation);
    }

    /**
     * Creates a LongRunningOperation with a new object
     *
     * @param newLongRunningOperation the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LongRunningOperation> postAsync(@Nonnull final LongRunningOperation newLongRunningOperation) {
        return sendAsync(HttpMethod.POST, newLongRunningOperation);
    }

    /**
     * Creates a LongRunningOperation with a new object
     *
     * @param newLongRunningOperation the new object to create
     * @return the created LongRunningOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LongRunningOperation post(@Nonnull final LongRunningOperation newLongRunningOperation) throws ClientException {
        return send(HttpMethod.POST, newLongRunningOperation);
    }

    /**
     * Creates a LongRunningOperation with a new object
     *
     * @param newLongRunningOperation the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LongRunningOperation> putAsync(@Nonnull final LongRunningOperation newLongRunningOperation) {
        return sendAsync(HttpMethod.PUT, newLongRunningOperation);
    }

    /**
     * Creates a LongRunningOperation with a new object
     *
     * @param newLongRunningOperation the object to create/update
     * @return the created LongRunningOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LongRunningOperation put(@Nonnull final LongRunningOperation newLongRunningOperation) throws ClientException {
        return send(HttpMethod.PUT, newLongRunningOperation);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public LongRunningOperationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public LongRunningOperationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

