// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.IdentityProtectionRoot;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Identity Protection Root Request Builder.
 */
public class IdentityProtectionRootRequestBuilder extends BaseRequestBuilder<IdentityProtectionRoot> {

    /**
     * The request builder for the IdentityProtectionRoot
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public IdentityProtectionRootRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IdentityProtectionRootRequest instance
     */
    @Nonnull
    public IdentityProtectionRootRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IdentityProtectionRootRequest instance
     */
    @Nonnull
    public IdentityProtectionRootRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.IdentityProtectionRootRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the RiskDetection collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.RiskDetectionCollectionRequestBuilder riskDetections() {
        return new com.microsoft.graph.requests.RiskDetectionCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("riskDetections"), getClient(), null);
    }

    /**
     * Gets a request builder for the RiskDetection item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.RiskDetectionRequestBuilder riskDetections(@Nonnull final String id) {
        return new com.microsoft.graph.requests.RiskDetectionRequestBuilder(getRequestUrlWithAdditionalSegment("riskDetections") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the RiskyServicePrincipal collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.RiskyServicePrincipalCollectionRequestBuilder riskyServicePrincipals() {
        return new com.microsoft.graph.requests.RiskyServicePrincipalCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("riskyServicePrincipals"), getClient(), null);
    }

    /**
     * Gets a request builder for the RiskyServicePrincipal item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.RiskyServicePrincipalRequestBuilder riskyServicePrincipals(@Nonnull final String id) {
        return new com.microsoft.graph.requests.RiskyServicePrincipalRequestBuilder(getRequestUrlWithAdditionalSegment("riskyServicePrincipals") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the RiskyUser collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.RiskyUserCollectionRequestBuilder riskyUsers() {
        return new com.microsoft.graph.requests.RiskyUserCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("riskyUsers"), getClient(), null);
    }

    /**
     * Gets a request builder for the RiskyUser item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.RiskyUserRequestBuilder riskyUsers(@Nonnull final String id) {
        return new com.microsoft.graph.requests.RiskyUserRequestBuilder(getRequestUrlWithAdditionalSegment("riskyUsers") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the ServicePrincipalRiskDetection collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.ServicePrincipalRiskDetectionCollectionRequestBuilder servicePrincipalRiskDetections() {
        return new com.microsoft.graph.requests.ServicePrincipalRiskDetectionCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("servicePrincipalRiskDetections"), getClient(), null);
    }

    /**
     * Gets a request builder for the ServicePrincipalRiskDetection item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.ServicePrincipalRiskDetectionRequestBuilder servicePrincipalRiskDetections(@Nonnull final String id) {
        return new com.microsoft.graph.requests.ServicePrincipalRiskDetectionRequestBuilder(getRequestUrlWithAdditionalSegment("servicePrincipalRiskDetections") + "/" + id, getClient(), null);
    }
}
