// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.EducationOutcome;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Education Outcome Request.
 */
public class EducationOutcomeRequest extends BaseRequest<EducationOutcome> {
	
    /**
     * The request for the EducationOutcome
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public EducationOutcomeRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends EducationOutcome> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the EducationOutcome
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EducationOutcomeRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EducationOutcome.class);
    }

    /**
     * Gets the EducationOutcome from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationOutcome> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the EducationOutcome from the service
     *
     * @return the EducationOutcome from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationOutcome get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationOutcome> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public EducationOutcome delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this EducationOutcome with a source
     *
     * @param sourceEducationOutcome the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationOutcome> patchAsync(@Nonnull final EducationOutcome sourceEducationOutcome) {
        return sendAsync(HttpMethod.PATCH, sourceEducationOutcome);
    }

    /**
     * Patches this EducationOutcome with a source
     *
     * @param sourceEducationOutcome the source object with updates
     * @return the updated EducationOutcome
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationOutcome patch(@Nonnull final EducationOutcome sourceEducationOutcome) throws ClientException {
        return send(HttpMethod.PATCH, sourceEducationOutcome);
    }

    /**
     * Creates a EducationOutcome with a new object
     *
     * @param newEducationOutcome the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationOutcome> postAsync(@Nonnull final EducationOutcome newEducationOutcome) {
        return sendAsync(HttpMethod.POST, newEducationOutcome);
    }

    /**
     * Creates a EducationOutcome with a new object
     *
     * @param newEducationOutcome the new object to create
     * @return the created EducationOutcome
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationOutcome post(@Nonnull final EducationOutcome newEducationOutcome) throws ClientException {
        return send(HttpMethod.POST, newEducationOutcome);
    }

    /**
     * Creates a EducationOutcome with a new object
     *
     * @param newEducationOutcome the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationOutcome> putAsync(@Nonnull final EducationOutcome newEducationOutcome) {
        return sendAsync(HttpMethod.PUT, newEducationOutcome);
    }

    /**
     * Creates a EducationOutcome with a new object
     *
     * @param newEducationOutcome the object to create/update
     * @return the created EducationOutcome
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationOutcome put(@Nonnull final EducationOutcome newEducationOutcome) throws ClientException {
        return send(HttpMethod.PUT, newEducationOutcome);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EducationOutcomeRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EducationOutcomeRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

