// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.EducationAssignmentDefaults;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Education Assignment Defaults Request.
 */
public class EducationAssignmentDefaultsRequest extends BaseRequest<EducationAssignmentDefaults> {
	
    /**
     * The request for the EducationAssignmentDefaults
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EducationAssignmentDefaultsRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EducationAssignmentDefaults.class);
    }

    /**
     * Gets the EducationAssignmentDefaults from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationAssignmentDefaults> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the EducationAssignmentDefaults from the service
     *
     * @return the EducationAssignmentDefaults from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationAssignmentDefaults get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationAssignmentDefaults> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public EducationAssignmentDefaults delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this EducationAssignmentDefaults with a source
     *
     * @param sourceEducationAssignmentDefaults the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationAssignmentDefaults> patchAsync(@Nonnull final EducationAssignmentDefaults sourceEducationAssignmentDefaults) {
        return sendAsync(HttpMethod.PATCH, sourceEducationAssignmentDefaults);
    }

    /**
     * Patches this EducationAssignmentDefaults with a source
     *
     * @param sourceEducationAssignmentDefaults the source object with updates
     * @return the updated EducationAssignmentDefaults
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationAssignmentDefaults patch(@Nonnull final EducationAssignmentDefaults sourceEducationAssignmentDefaults) throws ClientException {
        return send(HttpMethod.PATCH, sourceEducationAssignmentDefaults);
    }

    /**
     * Creates a EducationAssignmentDefaults with a new object
     *
     * @param newEducationAssignmentDefaults the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationAssignmentDefaults> postAsync(@Nonnull final EducationAssignmentDefaults newEducationAssignmentDefaults) {
        return sendAsync(HttpMethod.POST, newEducationAssignmentDefaults);
    }

    /**
     * Creates a EducationAssignmentDefaults with a new object
     *
     * @param newEducationAssignmentDefaults the new object to create
     * @return the created EducationAssignmentDefaults
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationAssignmentDefaults post(@Nonnull final EducationAssignmentDefaults newEducationAssignmentDefaults) throws ClientException {
        return send(HttpMethod.POST, newEducationAssignmentDefaults);
    }

    /**
     * Creates a EducationAssignmentDefaults with a new object
     *
     * @param newEducationAssignmentDefaults the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationAssignmentDefaults> putAsync(@Nonnull final EducationAssignmentDefaults newEducationAssignmentDefaults) {
        return sendAsync(HttpMethod.PUT, newEducationAssignmentDefaults);
    }

    /**
     * Creates a EducationAssignmentDefaults with a new object
     *
     * @param newEducationAssignmentDefaults the object to create/update
     * @return the created EducationAssignmentDefaults
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationAssignmentDefaults put(@Nonnull final EducationAssignmentDefaults newEducationAssignmentDefaults) throws ClientException {
        return send(HttpMethod.PUT, newEducationAssignmentDefaults);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EducationAssignmentDefaultsRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EducationAssignmentDefaultsRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

