// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DeletedTeam;
import com.microsoft.graph.models.ChatMessage;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Deleted Team Request.
 */
public class DeletedTeamRequest extends BaseRequest<DeletedTeam> {
	
    /**
     * The request for the DeletedTeam
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DeletedTeamRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeletedTeam.class);
    }

    /**
     * Gets the DeletedTeam from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeletedTeam> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the DeletedTeam from the service
     *
     * @return the DeletedTeam from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeletedTeam get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeletedTeam> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public DeletedTeam delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DeletedTeam with a source
     *
     * @param sourceDeletedTeam the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeletedTeam> patchAsync(@Nonnull final DeletedTeam sourceDeletedTeam) {
        return sendAsync(HttpMethod.PATCH, sourceDeletedTeam);
    }

    /**
     * Patches this DeletedTeam with a source
     *
     * @param sourceDeletedTeam the source object with updates
     * @return the updated DeletedTeam
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeletedTeam patch(@Nonnull final DeletedTeam sourceDeletedTeam) throws ClientException {
        return send(HttpMethod.PATCH, sourceDeletedTeam);
    }

    /**
     * Creates a DeletedTeam with a new object
     *
     * @param newDeletedTeam the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeletedTeam> postAsync(@Nonnull final DeletedTeam newDeletedTeam) {
        return sendAsync(HttpMethod.POST, newDeletedTeam);
    }

    /**
     * Creates a DeletedTeam with a new object
     *
     * @param newDeletedTeam the new object to create
     * @return the created DeletedTeam
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeletedTeam post(@Nonnull final DeletedTeam newDeletedTeam) throws ClientException {
        return send(HttpMethod.POST, newDeletedTeam);
    }

    /**
     * Creates a DeletedTeam with a new object
     *
     * @param newDeletedTeam the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeletedTeam> putAsync(@Nonnull final DeletedTeam newDeletedTeam) {
        return sendAsync(HttpMethod.PUT, newDeletedTeam);
    }

    /**
     * Creates a DeletedTeam with a new object
     *
     * @param newDeletedTeam the object to create/update
     * @return the created DeletedTeam
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeletedTeam put(@Nonnull final DeletedTeam newDeletedTeam) throws ClientException {
        return send(HttpMethod.PUT, newDeletedTeam);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public DeletedTeamRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public DeletedTeamRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

