// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DelegatedAdminAccessAssignment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Delegated Admin Access Assignment Request.
 */
public class DelegatedAdminAccessAssignmentRequest extends BaseRequest<DelegatedAdminAccessAssignment> {
	
    /**
     * The request for the DelegatedAdminAccessAssignment
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DelegatedAdminAccessAssignmentRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DelegatedAdminAccessAssignment.class);
    }

    /**
     * Gets the DelegatedAdminAccessAssignment from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DelegatedAdminAccessAssignment> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the DelegatedAdminAccessAssignment from the service
     *
     * @return the DelegatedAdminAccessAssignment from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DelegatedAdminAccessAssignment get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DelegatedAdminAccessAssignment> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public DelegatedAdminAccessAssignment delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DelegatedAdminAccessAssignment with a source
     *
     * @param sourceDelegatedAdminAccessAssignment the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DelegatedAdminAccessAssignment> patchAsync(@Nonnull final DelegatedAdminAccessAssignment sourceDelegatedAdminAccessAssignment) {
        return sendAsync(HttpMethod.PATCH, sourceDelegatedAdminAccessAssignment);
    }

    /**
     * Patches this DelegatedAdminAccessAssignment with a source
     *
     * @param sourceDelegatedAdminAccessAssignment the source object with updates
     * @return the updated DelegatedAdminAccessAssignment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DelegatedAdminAccessAssignment patch(@Nonnull final DelegatedAdminAccessAssignment sourceDelegatedAdminAccessAssignment) throws ClientException {
        return send(HttpMethod.PATCH, sourceDelegatedAdminAccessAssignment);
    }

    /**
     * Creates a DelegatedAdminAccessAssignment with a new object
     *
     * @param newDelegatedAdminAccessAssignment the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DelegatedAdminAccessAssignment> postAsync(@Nonnull final DelegatedAdminAccessAssignment newDelegatedAdminAccessAssignment) {
        return sendAsync(HttpMethod.POST, newDelegatedAdminAccessAssignment);
    }

    /**
     * Creates a DelegatedAdminAccessAssignment with a new object
     *
     * @param newDelegatedAdminAccessAssignment the new object to create
     * @return the created DelegatedAdminAccessAssignment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DelegatedAdminAccessAssignment post(@Nonnull final DelegatedAdminAccessAssignment newDelegatedAdminAccessAssignment) throws ClientException {
        return send(HttpMethod.POST, newDelegatedAdminAccessAssignment);
    }

    /**
     * Creates a DelegatedAdminAccessAssignment with a new object
     *
     * @param newDelegatedAdminAccessAssignment the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DelegatedAdminAccessAssignment> putAsync(@Nonnull final DelegatedAdminAccessAssignment newDelegatedAdminAccessAssignment) {
        return sendAsync(HttpMethod.PUT, newDelegatedAdminAccessAssignment);
    }

    /**
     * Creates a DelegatedAdminAccessAssignment with a new object
     *
     * @param newDelegatedAdminAccessAssignment the object to create/update
     * @return the created DelegatedAdminAccessAssignment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DelegatedAdminAccessAssignment put(@Nonnull final DelegatedAdminAccessAssignment newDelegatedAdminAccessAssignment) throws ClientException {
        return send(HttpMethod.PUT, newDelegatedAdminAccessAssignment);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public DelegatedAdminAccessAssignmentRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public DelegatedAdminAccessAssignmentRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

