// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AuthenticationStrengthRoot;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Authentication Strength Root Request.
 */
public class AuthenticationStrengthRootRequest extends BaseRequest<AuthenticationStrengthRoot> {
	
    /**
     * The request for the AuthenticationStrengthRoot
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AuthenticationStrengthRootRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AuthenticationStrengthRoot.class);
    }

    /**
     * Gets the AuthenticationStrengthRoot from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationStrengthRoot> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AuthenticationStrengthRoot from the service
     *
     * @return the AuthenticationStrengthRoot from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationStrengthRoot get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationStrengthRoot> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AuthenticationStrengthRoot delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AuthenticationStrengthRoot with a source
     *
     * @param sourceAuthenticationStrengthRoot the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationStrengthRoot> patchAsync(@Nonnull final AuthenticationStrengthRoot sourceAuthenticationStrengthRoot) {
        return sendAsync(HttpMethod.PATCH, sourceAuthenticationStrengthRoot);
    }

    /**
     * Patches this AuthenticationStrengthRoot with a source
     *
     * @param sourceAuthenticationStrengthRoot the source object with updates
     * @return the updated AuthenticationStrengthRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationStrengthRoot patch(@Nonnull final AuthenticationStrengthRoot sourceAuthenticationStrengthRoot) throws ClientException {
        return send(HttpMethod.PATCH, sourceAuthenticationStrengthRoot);
    }

    /**
     * Creates a AuthenticationStrengthRoot with a new object
     *
     * @param newAuthenticationStrengthRoot the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationStrengthRoot> postAsync(@Nonnull final AuthenticationStrengthRoot newAuthenticationStrengthRoot) {
        return sendAsync(HttpMethod.POST, newAuthenticationStrengthRoot);
    }

    /**
     * Creates a AuthenticationStrengthRoot with a new object
     *
     * @param newAuthenticationStrengthRoot the new object to create
     * @return the created AuthenticationStrengthRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationStrengthRoot post(@Nonnull final AuthenticationStrengthRoot newAuthenticationStrengthRoot) throws ClientException {
        return send(HttpMethod.POST, newAuthenticationStrengthRoot);
    }

    /**
     * Creates a AuthenticationStrengthRoot with a new object
     *
     * @param newAuthenticationStrengthRoot the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationStrengthRoot> putAsync(@Nonnull final AuthenticationStrengthRoot newAuthenticationStrengthRoot) {
        return sendAsync(HttpMethod.PUT, newAuthenticationStrengthRoot);
    }

    /**
     * Creates a AuthenticationStrengthRoot with a new object
     *
     * @param newAuthenticationStrengthRoot the object to create/update
     * @return the created AuthenticationStrengthRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationStrengthRoot put(@Nonnull final AuthenticationStrengthRoot newAuthenticationStrengthRoot) throws ClientException {
        return send(HttpMethod.PUT, newAuthenticationStrengthRoot);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AuthenticationStrengthRootRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AuthenticationStrengthRootRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

