// Template Source: BaseMethodRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.models.UserRegistrationMethodSummary;
import com.microsoft.graph.models.AuthenticationMethodsRoot;
import com.microsoft.graph.requests.AuthenticationMethodsRootUsersRegisteredByMethodRequest;

import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.models.AuthenticationMethodsRootUsersRegisteredByMethodParameterSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Authentication Methods Root Users Registered By Method Request.
 */
public class AuthenticationMethodsRootUsersRegisteredByMethodRequest extends BaseRequest<UserRegistrationMethodSummary> {
    /**
     * The request for this AuthenticationMethodsRootUsersRegisteredByMethod
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AuthenticationMethodsRootUsersRegisteredByMethodRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserRegistrationMethodSummary.class);
    }

    /**
     * Gets the UserRegistrationMethodSummary
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserRegistrationMethodSummary> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UserRegistrationMethodSummary
     *
     * @return the UserRegistrationMethodSummary
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    @Nullable
    public UserRegistrationMethodSummary get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    @Nonnull
    public AuthenticationMethodsRootUsersRegisteredByMethodRequest select(@Nonnull final String value) {
        addSelectOption(value);
        return this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    @Nonnull
    public AuthenticationMethodsRootUsersRegisteredByMethodRequest expand(@Nonnull final String value) {
        addExpandOption(value);
        return this;
    }

}
