// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AccessPackageResourceRequest;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Package Resource Request Request.
 */
public class AccessPackageResourceRequestRequest extends BaseRequest<AccessPackageResourceRequest> {
	
    /**
     * The request for the AccessPackageResourceRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AccessPackageResourceRequestRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AccessPackageResourceRequest.class);
    }

    /**
     * Gets the AccessPackageResourceRequest from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageResourceRequest> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AccessPackageResourceRequest from the service
     *
     * @return the AccessPackageResourceRequest from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageResourceRequest get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageResourceRequest> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AccessPackageResourceRequest delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AccessPackageResourceRequest with a source
     *
     * @param sourceAccessPackageResourceRequest the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageResourceRequest> patchAsync(@Nonnull final AccessPackageResourceRequest sourceAccessPackageResourceRequest) {
        return sendAsync(HttpMethod.PATCH, sourceAccessPackageResourceRequest);
    }

    /**
     * Patches this AccessPackageResourceRequest with a source
     *
     * @param sourceAccessPackageResourceRequest the source object with updates
     * @return the updated AccessPackageResourceRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageResourceRequest patch(@Nonnull final AccessPackageResourceRequest sourceAccessPackageResourceRequest) throws ClientException {
        return send(HttpMethod.PATCH, sourceAccessPackageResourceRequest);
    }

    /**
     * Creates a AccessPackageResourceRequest with a new object
     *
     * @param newAccessPackageResourceRequest the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageResourceRequest> postAsync(@Nonnull final AccessPackageResourceRequest newAccessPackageResourceRequest) {
        return sendAsync(HttpMethod.POST, newAccessPackageResourceRequest);
    }

    /**
     * Creates a AccessPackageResourceRequest with a new object
     *
     * @param newAccessPackageResourceRequest the new object to create
     * @return the created AccessPackageResourceRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageResourceRequest post(@Nonnull final AccessPackageResourceRequest newAccessPackageResourceRequest) throws ClientException {
        return send(HttpMethod.POST, newAccessPackageResourceRequest);
    }

    /**
     * Creates a AccessPackageResourceRequest with a new object
     *
     * @param newAccessPackageResourceRequest the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageResourceRequest> putAsync(@Nonnull final AccessPackageResourceRequest newAccessPackageResourceRequest) {
        return sendAsync(HttpMethod.PUT, newAccessPackageResourceRequest);
    }

    /**
     * Creates a AccessPackageResourceRequest with a new object
     *
     * @param newAccessPackageResourceRequest the object to create/update
     * @return the created AccessPackageResourceRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageResourceRequest put(@Nonnull final AccessPackageResourceRequest newAccessPackageResourceRequest) throws ClientException {
        return send(HttpMethod.PUT, newAccessPackageResourceRequest);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AccessPackageResourceRequestRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AccessPackageResourceRequestRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

