// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AccessPackageAssignment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.AccessPackageAssignmentAdditionalAccessCollectionRequestBuilder;
import com.microsoft.graph.requests.AccessPackageAssignmentAdditionalAccessCollectionRequest;
import com.microsoft.graph.requests.AccessPackageAssignmentAdditionalAccessCollectionResponse;
import com.microsoft.graph.models.AccessPackageAssignmentAdditionalAccessParameterSet;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseFunctionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Package Assignment Additional Access Collection Request Builder.
 */
public class AccessPackageAssignmentAdditionalAccessCollectionRequestBuilder extends BaseFunctionCollectionRequestBuilder<AccessPackageAssignment, AccessPackageAssignmentAdditionalAccessCollectionRequestBuilder, AccessPackageAssignmentAdditionalAccessCollectionResponse, AccessPackageAssignmentAdditionalAccessCollectionPage, AccessPackageAssignmentAdditionalAccessCollectionRequest> {

    /**
     * The request builder for this collection of AccessPackageAssignment
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AccessPackageAssignmentAdditionalAccessCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AccessPackageAssignmentAdditionalAccessCollectionRequestBuilder.class, AccessPackageAssignmentAdditionalAccessCollectionRequest.class);
    }
    /**
     * The request builder for this collection of AccessPackageAssignment
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public AccessPackageAssignmentAdditionalAccessCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final AccessPackageAssignmentAdditionalAccessParameterSet parameters) {
        super(requestUrl, client, requestOptions, AccessPackageAssignmentAdditionalAccessCollectionRequestBuilder.class, AccessPackageAssignmentAdditionalAccessCollectionRequest.class);
        if(parameters != null) {
            functionOptions = parameters.getFunctionOptions();
        }
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the AccessPackageAssignmentAdditionalAccessCollectionRequest instance
     */
    @Override
    @Nonnull
    public AccessPackageAssignmentAdditionalAccessCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final AccessPackageAssignmentAdditionalAccessCollectionRequest request = super.buildRequest(requestOptions);
        if(functionOptions != null) {    
            for (com.microsoft.graph.options.FunctionOption option : functionOptions) {
                request.addFunctionOption(option);
            }
        }
        return request;
    }
}
