// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Hyp Geom_Dist Parameter Set.
 */
public class WorkbookFunctionsHypGeom_DistParameterSet {
    /**
     * The sample S.
     * 
     */
    @SerializedName(value = "sampleS", alternate = {"SampleS"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement sampleS;

    /**
     * The number Sample.
     * 
     */
    @SerializedName(value = "numberSample", alternate = {"NumberSample"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement numberSample;

    /**
     * The population S.
     * 
     */
    @SerializedName(value = "populationS", alternate = {"PopulationS"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement populationS;

    /**
     * The number Pop.
     * 
     */
    @SerializedName(value = "numberPop", alternate = {"NumberPop"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement numberPop;

    /**
     * The cumulative.
     * 
     */
    @SerializedName(value = "cumulative", alternate = {"Cumulative"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement cumulative;


    /**
     * Instiaciates a new WorkbookFunctionsHypGeom_DistParameterSet
     */
    public WorkbookFunctionsHypGeom_DistParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsHypGeom_DistParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsHypGeom_DistParameterSet(@Nonnull final WorkbookFunctionsHypGeom_DistParameterSetBuilder builder) {
        this.sampleS = builder.sampleS;
        this.numberSample = builder.numberSample;
        this.populationS = builder.populationS;
        this.numberPop = builder.numberPop;
        this.cumulative = builder.cumulative;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsHypGeom_DistParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsHypGeom_DistParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsHypGeom_DistParameterSet
     */
    public static final class WorkbookFunctionsHypGeom_DistParameterSetBuilder {
        /**
         * The sampleS parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement sampleS;
        /**
         * Sets the SampleS
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsHypGeom_DistParameterSetBuilder withSampleS(@Nullable final com.google.gson.JsonElement val) {
            this.sampleS = val;
            return this;
        }
        /**
         * The numberSample parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement numberSample;
        /**
         * Sets the NumberSample
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsHypGeom_DistParameterSetBuilder withNumberSample(@Nullable final com.google.gson.JsonElement val) {
            this.numberSample = val;
            return this;
        }
        /**
         * The populationS parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement populationS;
        /**
         * Sets the PopulationS
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsHypGeom_DistParameterSetBuilder withPopulationS(@Nullable final com.google.gson.JsonElement val) {
            this.populationS = val;
            return this;
        }
        /**
         * The numberPop parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement numberPop;
        /**
         * Sets the NumberPop
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsHypGeom_DistParameterSetBuilder withNumberPop(@Nullable final com.google.gson.JsonElement val) {
            this.numberPop = val;
            return this;
        }
        /**
         * The cumulative parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement cumulative;
        /**
         * Sets the Cumulative
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsHypGeom_DistParameterSetBuilder withCumulative(@Nullable final com.google.gson.JsonElement val) {
            this.cumulative = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsHypGeom_DistParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsHypGeom_DistParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsHypGeom_DistParameterSet build() {
            return new WorkbookFunctionsHypGeom_DistParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.sampleS != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("sampleS", sampleS));
        }
        if(this.numberSample != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("numberSample", numberSample));
        }
        if(this.populationS != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("populationS", populationS));
        }
        if(this.numberPop != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("numberPop", numberPop));
        }
        if(this.cumulative != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("cumulative", cumulative));
        }
        return result;
    }
}
