// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Datevalue Parameter Set.
 */
public class WorkbookFunctionsDatevalueParameterSet {
    /**
     * The date Text.
     * 
     */
    @SerializedName(value = "dateText", alternate = {"DateText"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement dateText;


    /**
     * Instiaciates a new WorkbookFunctionsDatevalueParameterSet
     */
    public WorkbookFunctionsDatevalueParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsDatevalueParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsDatevalueParameterSet(@Nonnull final WorkbookFunctionsDatevalueParameterSetBuilder builder) {
        this.dateText = builder.dateText;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsDatevalueParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsDatevalueParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsDatevalueParameterSet
     */
    public static final class WorkbookFunctionsDatevalueParameterSetBuilder {
        /**
         * The dateText parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement dateText;
        /**
         * Sets the DateText
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsDatevalueParameterSetBuilder withDateText(@Nullable final com.google.gson.JsonElement val) {
            this.dateText = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsDatevalueParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsDatevalueParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsDatevalueParameterSet build() {
            return new WorkbookFunctionsDatevalueParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.dateText != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("dateText", dateText));
        }
        return result;
    }
}
