// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.WindowsMalwareCategory;
import com.microsoft.graph.models.WindowsMalwareSeverity;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.MalwareStateForWindowsDeviceCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows Malware Information.
 */
public class WindowsMalwareInformation extends Entity implements IJsonBackedObject {


    /**
     * The Additional Information Url.
     * Indicates an informational URL to learn more about the malware
     */
    @SerializedName(value = "additionalInformationUrl", alternate = {"AdditionalInformationUrl"})
    @Expose
	@Nullable
    public String additionalInformationUrl;

    /**
     * The Category.
     * Category of the malware. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remoteControlSoftware, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule. default value is invalid. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remoteControlSoftware, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule.
     */
    @SerializedName(value = "category", alternate = {"Category"})
    @Expose
	@Nullable
    public WindowsMalwareCategory category;

    /**
     * The Display Name.
     * Indicates the name of the malware
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Last Detection Date Time.
     * Indicates the last time the malware was detected in UTC
     */
    @SerializedName(value = "lastDetectionDateTime", alternate = {"LastDetectionDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastDetectionDateTime;

    /**
     * The Severity.
     * Severity of the malware. Possible values are: unknown, low, moderate, high, severe. default is unknown. Possible values are: unknown, low, moderate, high, severe.
     */
    @SerializedName(value = "severity", alternate = {"Severity"})
    @Expose
	@Nullable
    public WindowsMalwareSeverity severity;

    /**
     * The Device Malware States.
     * List of devices affected by current malware with the malware state on each device
     */
    @SerializedName(value = "deviceMalwareStates", alternate = {"DeviceMalwareStates"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.MalwareStateForWindowsDeviceCollectionPage deviceMalwareStates;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("deviceMalwareStates")) {
            deviceMalwareStates = serializer.deserializeObject(json.get("deviceMalwareStates"), com.microsoft.graph.requests.MalwareStateForWindowsDeviceCollectionPage.class);
        }
    }
}
