// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.UserSignInRecommendationScope;
import com.microsoft.graph.models.AccessReviewRecommendationInsightSetting;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Last Sign In Recommendation Insight Setting.
 */
public class UserLastSignInRecommendationInsightSetting extends AccessReviewRecommendationInsightSetting implements IJsonBackedObject {


    /**
     * The Recommendation Look Back Duration.
     * Optional. Indicates the time period of inactivity (with respect to the start date of the review instance) that recommendations will be configured from. The recommendation will be to deny if the user is inactive during the look-back duration. For reviews of groups and Azure AD roles, any duration is accepted. For reviews of applications, 30 days is the maximum duration. If not specified, the duration is 30 days.
     */
    @SerializedName(value = "recommendationLookBackDuration", alternate = {"RecommendationLookBackDuration"})
    @Expose
	@Nullable
    public javax.xml.datatype.Duration recommendationLookBackDuration;

    /**
     * The Sign In Scope.
     * Indicates whether inactivity is calculated based on the user's inactivity in the tenant or in the application. The possible values are tenant, application, unknownFutureValue. application is only relevant when the access review is a review of an assignment to an application.
     */
    @SerializedName(value = "signInScope", alternate = {"SignInScope"})
    @Expose
	@Nullable
    public UserSignInRecommendationScope signInScope;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
