// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.UnifiedRoleManagementPolicy;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Unified Role Management Policy Assignment.
 */
public class UnifiedRoleManagementPolicyAssignment extends Entity implements IJsonBackedObject {


    /**
     * The Policy Id.
     * The id of the policy. Inherited from entity.
     */
    @SerializedName(value = "policyId", alternate = {"PolicyId"})
    @Expose
	@Nullable
    public String policyId;

    /**
     * The Role Definition Id.
     * The identifier of the role definition object where the policy applies. If not specified, the policy applies to all roles. Supports $filter (eq).
     */
    @SerializedName(value = "roleDefinitionId", alternate = {"RoleDefinitionId"})
    @Expose
	@Nullable
    public String roleDefinitionId;

    /**
     * The Scope Id.
     * The identifier of the scope where the policy is assigned.  Can be / for the tenant or a group ID. Required.
     */
    @SerializedName(value = "scopeId", alternate = {"ScopeId"})
    @Expose
	@Nullable
    public String scopeId;

    /**
     * The Scope Type.
     * The type of the scope where the policy is assigned. One of Directory, DirectoryRole. Required.
     */
    @SerializedName(value = "scopeType", alternate = {"ScopeType"})
    @Expose
	@Nullable
    public String scopeType;

    /**
     * The Policy.
     * The policy that's associated with a policy assignment. Supports $expand and a nested $expand of the rules and effectiveRules relationships for the policy.
     */
    @SerializedName(value = "policy", alternate = {"Policy"})
    @Expose
	@Nullable
    public UnifiedRoleManagementPolicy policy;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
