// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.UnifiedRolePermission;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.UnifiedRoleDefinitionCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Unified Role Definition.
 */
public class UnifiedRoleDefinition extends Entity implements IJsonBackedObject {


    /**
     * The Description.
     * The description for the unifiedRoleDefinition. Read-only when isBuiltIn is true.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Display Name.
     * The display name for the unifiedRoleDefinition. Read-only when isBuiltIn is true. Required.  Supports $filter (eq, in).
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Is Built In.
     * Flag indicating whether the role definition is part of the default set included in Azure Active Directory (Azure AD) or a custom definition. Read-only. Supports $filter (eq, in).
     */
    @SerializedName(value = "isBuiltIn", alternate = {"IsBuiltIn"})
    @Expose
	@Nullable
    public Boolean isBuiltIn;

    /**
     * The Is Enabled.
     * Flag indicating whether the role is enabled for assignment. If false the role is not available for assignment. Read-only when isBuiltIn is true.
     */
    @SerializedName(value = "isEnabled", alternate = {"IsEnabled"})
    @Expose
	@Nullable
    public Boolean isEnabled;

    /**
     * The Resource Scopes.
     * List of the scopes or permissions the role definition applies to. Currently only / is supported. Read-only when isBuiltIn is true. DO NOT USE. This will be deprecated soon. Attach scope to role assignment.
     */
    @SerializedName(value = "resourceScopes", alternate = {"ResourceScopes"})
    @Expose
	@Nullable
    public java.util.List<String> resourceScopes;

    /**
     * The Role Permissions.
     * List of permissions included in the role. Read-only when isBuiltIn is true. Required.
     */
    @SerializedName(value = "rolePermissions", alternate = {"RolePermissions"})
    @Expose
	@Nullable
    public java.util.List<UnifiedRolePermission> rolePermissions;

    /**
     * The Template Id.
     * Custom template identifier that can be set when isBuiltIn is false but is read-only when isBuiltIn is true. This identifier is typically used if one needs an identifier to be the same across different directories.
     */
    @SerializedName(value = "templateId", alternate = {"TemplateId"})
    @Expose
	@Nullable
    public String templateId;

    /**
     * The Version.
     * Indicates version of the role definition. Read-only when isBuiltIn is true.
     */
    @SerializedName(value = "version", alternate = {"Version"})
    @Expose
	@Nullable
    public String version;

    /**
     * The Inherits Permissions From.
     * Read-only collection of role definitions that the given role definition inherits from. Only Azure AD built-in roles (isBuiltIn is true) support this attribute. Supports $expand.
     */
    @SerializedName(value = "inheritsPermissionsFrom", alternate = {"InheritsPermissionsFrom"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.UnifiedRoleDefinitionCollectionPage inheritsPermissionsFrom;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("inheritsPermissionsFrom")) {
            inheritsPermissionsFrom = serializer.deserializeObject(json.get("inheritsPermissionsFrom"), com.microsoft.graph.requests.UnifiedRoleDefinitionCollectionPage.class);
        }
    }
}
