// Template Source: Enum.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


/**
 * The Enum Synchronization Secret.
*/
public enum SynchronizationSecret
{
    /**
    * None
    */
    NONE,
    /**
    * User Name
    */
    USER_NAME,
    /**
    * Password
    */
    PASSWORD,
    /**
    * Secret Token
    */
    SECRET_TOKEN,
    /**
    * App Key
    */
    APP_KEY,
    /**
    * Base Address
    */
    BASE_ADDRESS,
    /**
    * Client Identifier
    */
    CLIENT_IDENTIFIER,
    /**
    * Client Secret
    */
    CLIENT_SECRET,
    /**
    * Single Sign On Type
    */
    SINGLE_SIGN_ON_TYPE,
    /**
    * Sandbox
    */
    SANDBOX,
    /**
    * Url
    */
    URL,
    /**
    * Domain
    */
    DOMAIN,
    /**
    * Consumer Key
    */
    CONSUMER_KEY,
    /**
    * Consumer Secret
    */
    CONSUMER_SECRET,
    /**
    * Token Key
    */
    TOKEN_KEY,
    /**
    * Token Expiration
    */
    TOKEN_EXPIRATION,
    /**
    * Oauth2Access Token
    */
    OAUTH2_ACCESS_TOKEN,
    /**
    * Oauth2Access Token Creation Time
    */
    OAUTH2_ACCESS_TOKEN_CREATION_TIME,
    /**
    * Oauth2Refresh Token
    */
    OAUTH2_REFRESH_TOKEN,
    /**
    * Sync All
    */
    SYNC_ALL,
    /**
    * Instance Name
    */
    INSTANCE_NAME,
    /**
    * Oauth2Client Id
    */
    OAUTH2_CLIENT_ID,
    /**
    * Oauth2Client Secret
    */
    OAUTH2_CLIENT_SECRET,
    /**
    * Company Id
    */
    COMPANY_ID,
    /**
    * Update Key On Soft Delete
    */
    UPDATE_KEY_ON_SOFT_DELETE,
    /**
    * Synchronization Schedule
    */
    SYNCHRONIZATION_SCHEDULE,
    /**
    * System Of Record
    */
    SYSTEM_OF_RECORD,
    /**
    * Sandbox Name
    */
    SANDBOX_NAME,
    /**
    * Enforce Domain
    */
    ENFORCE_DOMAIN,
    /**
    * Sync Notification Settings
    */
    SYNC_NOTIFICATION_SETTINGS,
    /**
    * Skip Out Of Scope Deletions
    */
    SKIP_OUT_OF_SCOPE_DELETIONS,
    /**
    * Oauth2Authorization Code
    */
    OAUTH2_AUTHORIZATION_CODE,
    /**
    * Oauth2Redirect Uri
    */
    OAUTH2_REDIRECT_URI,
    /**
    * Application Template Identifier
    */
    APPLICATION_TEMPLATE_IDENTIFIER,
    /**
    * Oauth2Token Exchange Uri
    */
    OAUTH2_TOKEN_EXCHANGE_URI,
    /**
    * Oauth2Authorization Uri
    */
    OAUTH2_AUTHORIZATION_URI,
    /**
    * Authentication Type
    */
    AUTHENTICATION_TYPE,
    /**
    * Server
    */
    SERVER,
    /**
    * Perform Inbound Entitlement Grants
    */
    PERFORM_INBOUND_ENTITLEMENT_GRANTS,
    /**
    * Hard Deletes Enabled
    */
    HARD_DELETES_ENABLED,
    /**
    * Sync Agent Compatibility Key
    */
    SYNC_AGENT_COMPATIBILITY_KEY,
    /**
    * Sync Agent ADContainer
    */
    SYNC_AGENT_AD_CONTAINER,
    /**
    * Validate Domain
    */
    VALIDATE_DOMAIN,
    /**
    * Test References
    */
    TEST_REFERENCES,
    /**
    * Connection String
    */
    CONNECTION_STRING,
    /**
    * For SynchronizationSecret values that were not expected from the service
    */
    UNEXPECTED_VALUE
}
