// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.RiskDetail;
import com.microsoft.graph.models.RiskLevel;
import com.microsoft.graph.models.RiskState;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.RiskyUserHistoryItemCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Risky User.
 */
public class RiskyUser extends Entity implements IJsonBackedObject {


    /**
     * The Is Deleted.
     * Indicates whether the user is deleted. Possible values are: true, false.
     */
    @SerializedName(value = "isDeleted", alternate = {"IsDeleted"})
    @Expose
	@Nullable
    public Boolean isDeleted;

    /**
     * The Is Processing.
     * Indicates whether a user's risky state is being processed by the backend.
     */
    @SerializedName(value = "isProcessing", alternate = {"IsProcessing"})
    @Expose
	@Nullable
    public Boolean isProcessing;

    /**
     * The Risk Detail.
     * Details of the detected risk. Possible values are: none, adminGeneratedTemporaryPassword, userPerformedSecuredPasswordChange, userPerformedSecuredPasswordReset, adminConfirmedSigninSafe, aiConfirmedSigninSafe, userPassedMFADrivenByRiskBasedPolicy, adminDismissedAllRiskForUser, adminConfirmedSigninCompromised, hidden, adminConfirmedUserCompromised, unknownFutureValue.
     */
    @SerializedName(value = "riskDetail", alternate = {"RiskDetail"})
    @Expose
	@Nullable
    public RiskDetail riskDetail;

    /**
     * The Risk Last Updated Date Time.
     * The date and time that the risky user was last updated.  The DateTimeOffset type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
     */
    @SerializedName(value = "riskLastUpdatedDateTime", alternate = {"RiskLastUpdatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime riskLastUpdatedDateTime;

    /**
     * The Risk Level.
     * Level of the detected risky user. Possible values are: low, medium, high, hidden, none, unknownFutureValue.
     */
    @SerializedName(value = "riskLevel", alternate = {"RiskLevel"})
    @Expose
	@Nullable
    public RiskLevel riskLevel;

    /**
     * The Risk State.
     * State of the user's risk. Possible values are: none, confirmedSafe, remediated, dismissed, atRisk, confirmedCompromised, unknownFutureValue.
     */
    @SerializedName(value = "riskState", alternate = {"RiskState"})
    @Expose
	@Nullable
    public RiskState riskState;

    /**
     * The User Display Name.
     * Risky user display name.
     */
    @SerializedName(value = "userDisplayName", alternate = {"UserDisplayName"})
    @Expose
	@Nullable
    public String userDisplayName;

    /**
     * The User Principal Name.
     * Risky user principal name.
     */
    @SerializedName(value = "userPrincipalName", alternate = {"UserPrincipalName"})
    @Expose
	@Nullable
    public String userPrincipalName;

    /**
     * The History.
     * The activity related to user risk level change
     */
    @SerializedName(value = "history", alternate = {"History"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.RiskyUserHistoryItemCollectionPage history;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("history")) {
            history = serializer.deserializeObject(json.get("history"), com.microsoft.graph.requests.RiskyUserHistoryItemCollectionPage.class);
        }
    }
}
