// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.ArchivedPrintJob;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Report Root Get Printer Archived Print Jobs Parameter Set.
 */
public class ReportRootGetPrinterArchivedPrintJobsParameterSet {
    /**
     * The printer Id.
     * 
     */
    @SerializedName(value = "printerId", alternate = {"PrinterId"})
    @Expose
	@Nullable
    public String printerId;

    /**
     * The start Date Time.
     * 
     */
    @SerializedName(value = "startDateTime", alternate = {"StartDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime startDateTime;

    /**
     * The end Date Time.
     * 
     */
    @SerializedName(value = "endDateTime", alternate = {"EndDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime endDateTime;


    /**
     * Instiaciates a new ReportRootGetPrinterArchivedPrintJobsParameterSet
     */
    public ReportRootGetPrinterArchivedPrintJobsParameterSet() {}
    /**
     * Instiaciates a new ReportRootGetPrinterArchivedPrintJobsParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected ReportRootGetPrinterArchivedPrintJobsParameterSet(@Nonnull final ReportRootGetPrinterArchivedPrintJobsParameterSetBuilder builder) {
        this.printerId = builder.printerId;
        this.startDateTime = builder.startDateTime;
        this.endDateTime = builder.endDateTime;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static ReportRootGetPrinterArchivedPrintJobsParameterSetBuilder newBuilder() {
        return new ReportRootGetPrinterArchivedPrintJobsParameterSetBuilder();
    }
    /**
     * Fluent builder for the ReportRootGetPrinterArchivedPrintJobsParameterSet
     */
    public static final class ReportRootGetPrinterArchivedPrintJobsParameterSetBuilder {
        /**
         * The printerId parameter value
         */
        @Nullable
        protected String printerId;
        /**
         * Sets the PrinterId
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ReportRootGetPrinterArchivedPrintJobsParameterSetBuilder withPrinterId(@Nullable final String val) {
            this.printerId = val;
            return this;
        }
        /**
         * The startDateTime parameter value
         */
        @Nullable
        protected java.time.OffsetDateTime startDateTime;
        /**
         * Sets the StartDateTime
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ReportRootGetPrinterArchivedPrintJobsParameterSetBuilder withStartDateTime(@Nullable final java.time.OffsetDateTime val) {
            this.startDateTime = val;
            return this;
        }
        /**
         * The endDateTime parameter value
         */
        @Nullable
        protected java.time.OffsetDateTime endDateTime;
        /**
         * Sets the EndDateTime
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ReportRootGetPrinterArchivedPrintJobsParameterSetBuilder withEndDateTime(@Nullable final java.time.OffsetDateTime val) {
            this.endDateTime = val;
            return this;
        }
        /**
         * Instanciates a new ReportRootGetPrinterArchivedPrintJobsParameterSetBuilder
         */
        @Nullable
        protected ReportRootGetPrinterArchivedPrintJobsParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public ReportRootGetPrinterArchivedPrintJobsParameterSet build() {
            return new ReportRootGetPrinterArchivedPrintJobsParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.printerId != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("printerId", printerId));
        }
        if(this.startDateTime != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("startDateTime", startDateTime));
        }
        if(this.endDateTime != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("endDateTime", endDateTime));
        }
        return result;
    }
}
