// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.AuthenticationMethodsRoot;
import com.microsoft.graph.models.SecurityReportsRoot;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Report Root.
 */
public class ReportRoot implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Authentication Methods.
     * Container for navigation properties for Azure AD authentication methods resources.
     */
    @SerializedName(value = "authenticationMethods", alternate = {"AuthenticationMethods"})
    @Expose
	@Nullable
    public AuthenticationMethodsRoot authenticationMethods;

    /**
     * The Daily Print Usage By Printer.
     * Retrieve a list of daily print usage summaries, grouped by printer.
     */
    @SerializedName(value = "dailyPrintUsageByPrinter", alternate = {"DailyPrintUsageByPrinter"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.PrintUsageByPrinterCollectionPage dailyPrintUsageByPrinter;

    /**
     * The Daily Print Usage By User.
     * Retrieve a list of daily print usage summaries, grouped by user.
     */
    @SerializedName(value = "dailyPrintUsageByUser", alternate = {"DailyPrintUsageByUser"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.PrintUsageByUserCollectionPage dailyPrintUsageByUser;

    /**
     * The Monthly Print Usage By Printer.
     * Retrieve a list of monthly print usage summaries, grouped by printer.
     */
    @SerializedName(value = "monthlyPrintUsageByPrinter", alternate = {"MonthlyPrintUsageByPrinter"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.PrintUsageByPrinterCollectionPage monthlyPrintUsageByPrinter;

    /**
     * The Monthly Print Usage By User.
     * Retrieve a list of monthly print usage summaries, grouped by user.
     */
    @SerializedName(value = "monthlyPrintUsageByUser", alternate = {"MonthlyPrintUsageByUser"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.PrintUsageByUserCollectionPage monthlyPrintUsageByUser;

    /**
     * The Security.
     * Represents an abstract type that contains resources for attack simulation and training reports.
     */
    @SerializedName(value = "security", alternate = {"Security"})
    @Expose
	@Nullable
    public SecurityReportsRoot security;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("dailyPrintUsageByPrinter")) {
            dailyPrintUsageByPrinter = serializer.deserializeObject(json.get("dailyPrintUsageByPrinter"), com.microsoft.graph.requests.PrintUsageByPrinterCollectionPage.class);
        }

        if (json.has("dailyPrintUsageByUser")) {
            dailyPrintUsageByUser = serializer.deserializeObject(json.get("dailyPrintUsageByUser"), com.microsoft.graph.requests.PrintUsageByUserCollectionPage.class);
        }

        if (json.has("monthlyPrintUsageByPrinter")) {
            monthlyPrintUsageByPrinter = serializer.deserializeObject(json.get("monthlyPrintUsageByPrinter"), com.microsoft.graph.requests.PrintUsageByPrinterCollectionPage.class);
        }

        if (json.has("monthlyPrintUsageByUser")) {
            monthlyPrintUsageByUser = serializer.deserializeObject(json.get("monthlyPrintUsageByUser"), com.microsoft.graph.requests.PrintUsageByUserCollectionPage.class);
        }
    }
}
