// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.AttributeMapping;
import com.microsoft.graph.models.ObjectFlowTypes;
import com.microsoft.graph.models.ObjectMappingMetadataEntry;
import com.microsoft.graph.models.Filter;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Object Mapping.
 */
public class ObjectMapping implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Attribute Mappings.
     * Attribute mappings define which attributes to map from the source object into the target object and how they should flow. A number of functions are available to support the transformation of the original source values.
     */
    @SerializedName(value = "attributeMappings", alternate = {"AttributeMappings"})
    @Expose
	@Nullable
    public java.util.List<AttributeMapping> attributeMappings;

    /**
     * The Enabled.
     * When true, this object mapping will be processed during synchronization. When false, this object mapping will be skipped.
     */
    @SerializedName(value = "enabled", alternate = {"Enabled"})
    @Expose
	@Nullable
    public Boolean enabled;

    /**
     * The Flow Types.
     * Which flow types are enabled for this object mapping. Add creates new objects in the target directory, Update modifies existing objects, and Delete deprovisions existing users. The default is Add, Update, Delete.
     */
    @SerializedName(value = "flowTypes", alternate = {"FlowTypes"})
    @Expose
	@Nullable
    public EnumSet<ObjectFlowTypes> flowTypes;

    /**
     * The Metadata.
     * Additional extension properties. Unless mentioned explicitly, metadata values should not be changed.
     */
    @SerializedName(value = "metadata", alternate = {"Metadata"})
    @Expose
	@Nullable
    public java.util.List<ObjectMappingMetadataEntry> metadata;

    /**
     * The Name.
     * Human-friendly name of the object mapping.
     */
    @SerializedName(value = "name", alternate = {"Name"})
    @Expose
	@Nullable
    public String name;

    /**
     * The Scope.
     * Defines a filter to be used when deciding whether a given object should be provisioned. For example, you might want to only provision users that are located in the US.
     */
    @SerializedName(value = "scope", alternate = {"Scope"})
    @Expose
	@Nullable
    public Filter scope;

    /**
     * The Source Object Name.
     * Name of the object in the source directory. Must match the object name from the source directory definition.
     */
    @SerializedName(value = "sourceObjectName", alternate = {"SourceObjectName"})
    @Expose
	@Nullable
    public String sourceObjectName;

    /**
     * The Target Object Name.
     * Name of the object in target directory. Must match the object name from the target directory definition.
     */
    @SerializedName(value = "targetObjectName", alternate = {"TargetObjectName"})
    @Expose
	@Nullable
    public String targetObjectName;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
