// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.AttributeDefinition;
import com.microsoft.graph.models.ObjectDefinitionMetadataEntry;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Object Definition.
 */
public class ObjectDefinition implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Attributes.
     * Defines attributes of the object.
     */
    @SerializedName(value = "attributes", alternate = {"Attributes"})
    @Expose
	@Nullable
    public java.util.List<AttributeDefinition> attributes;

    /**
     * The Metadata.
     * Metadata for the given object.
     */
    @SerializedName(value = "metadata", alternate = {"Metadata"})
    @Expose
	@Nullable
    public java.util.List<ObjectDefinitionMetadataEntry> metadata;

    /**
     * The Name.
     * Name of the object. Must be unique within a directory definition. Not nullable.
     */
    @SerializedName(value = "name", alternate = {"Name"})
    @Expose
	@Nullable
    public String name;

    /**
     * The Supported Apis.
     * The API that the provisioning service queries to retrieve data for synchronization.
     */
    @SerializedName(value = "supportedApis", alternate = {"SupportedApis"})
    @Expose
	@Nullable
    public java.util.List<String> supportedApis;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
