// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.MobileAppIdentifier;
import com.microsoft.graph.models.ManagedAppFlaggedReason;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.ManagedAppOperationCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Managed App Registration.
 */
public class ManagedAppRegistration extends Entity implements IJsonBackedObject {


    /**
     * The App Identifier.
     * The app package Identifier
     */
    @SerializedName(value = "appIdentifier", alternate = {"AppIdentifier"})
    @Expose
	@Nullable
    public MobileAppIdentifier appIdentifier;

    /**
     * The Application Version.
     * App version
     */
    @SerializedName(value = "applicationVersion", alternate = {"ApplicationVersion"})
    @Expose
	@Nullable
    public String applicationVersion;

    /**
     * The Created Date Time.
     * Date and time of creation
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdDateTime;

    /**
     * The Device Name.
     * Host device name
     */
    @SerializedName(value = "deviceName", alternate = {"DeviceName"})
    @Expose
	@Nullable
    public String deviceName;

    /**
     * The Device Tag.
     * App management SDK generated tag, which helps relate apps hosted on the same device. Not guaranteed to relate apps in all conditions.
     */
    @SerializedName(value = "deviceTag", alternate = {"DeviceTag"})
    @Expose
	@Nullable
    public String deviceTag;

    /**
     * The Device Type.
     * Host device type
     */
    @SerializedName(value = "deviceType", alternate = {"DeviceType"})
    @Expose
	@Nullable
    public String deviceType;

    /**
     * The Flagged Reasons.
     * Zero or more reasons an app registration is flagged. E.g. app running on rooted device
     */
    @SerializedName(value = "flaggedReasons", alternate = {"FlaggedReasons"})
    @Expose
	@Nullable
    public java.util.List<ManagedAppFlaggedReason> flaggedReasons;

    /**
     * The Last Sync Date Time.
     * Date and time of last the app synced with management service.
     */
    @SerializedName(value = "lastSyncDateTime", alternate = {"LastSyncDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastSyncDateTime;

    /**
     * The Management Sdk Version.
     * App management SDK version
     */
    @SerializedName(value = "managementSdkVersion", alternate = {"ManagementSdkVersion"})
    @Expose
	@Nullable
    public String managementSdkVersion;

    /**
     * The Platform Version.
     * Operating System version
     */
    @SerializedName(value = "platformVersion", alternate = {"PlatformVersion"})
    @Expose
	@Nullable
    public String platformVersion;

    /**
     * The User Id.
     * The user Id to who this app registration belongs.
     */
    @SerializedName(value = "userId", alternate = {"UserId"})
    @Expose
	@Nullable
    public String userId;

    /**
     * The Version.
     * Version of the entity.
     */
    @SerializedName(value = "version", alternate = {"Version"})
    @Expose
	@Nullable
    public String version;

    /**
     * The Applied Policies.
     * Zero or more policys already applied on the registered app when it last synchronized with managment service.
     */
    @SerializedName(value = "appliedPolicies", alternate = {"AppliedPolicies"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.ManagedAppPolicyCollectionPage appliedPolicies;

    /**
     * The Intended Policies.
     * Zero or more policies admin intended for the app as of now.
     */
    @SerializedName(value = "intendedPolicies", alternate = {"IntendedPolicies"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.ManagedAppPolicyCollectionPage intendedPolicies;

    /**
     * The Operations.
     * Zero or more long running operations triggered on the app registration.
     */
    @SerializedName(value = "operations", alternate = {"Operations"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.ManagedAppOperationCollectionPage operations;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("appliedPolicies")) {
            appliedPolicies = serializer.deserializeObject(json.get("appliedPolicies"), com.microsoft.graph.requests.ManagedAppPolicyCollectionPage.class);
        }

        if (json.has("intendedPolicies")) {
            intendedPolicies = serializer.deserializeObject(json.get("intendedPolicies"), com.microsoft.graph.requests.ManagedAppPolicyCollectionPage.class);
        }

        if (json.has("operations")) {
            operations = serializer.deserializeObject(json.get("operations"), com.microsoft.graph.requests.ManagedAppOperationCollectionPage.class);
        }
    }
}
