// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.FilterOperand;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Filter Clause.
 */
public class FilterClause implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Operator Name.
     * Name of the operator to be applied to the source and target operands. Must be one of the supported operators. Supported operators can be discovered.
     */
    @SerializedName(value = "operatorName", alternate = {"OperatorName"})
    @Expose
	@Nullable
    public String operatorName;

    /**
     * The Source Operand Name.
     * Name of source operand (the operand being tested). The source operand name must match one of the attribute names on the source object.
     */
    @SerializedName(value = "sourceOperandName", alternate = {"SourceOperandName"})
    @Expose
	@Nullable
    public String sourceOperandName;

    /**
     * The Target Operand.
     * Values that the source operand will be tested against.
     */
    @SerializedName(value = "targetOperand", alternate = {"TargetOperand"})
    @Expose
	@Nullable
    public FilterOperand targetOperand;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
