// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.ItemPreviewInfo;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Drive Item Preview Parameter Set.
 */
public class DriveItemPreviewParameterSet {
    /**
     * The page.
     * 
     */
    @SerializedName(value = "page", alternate = {"Page"})
    @Expose
	@Nullable
    public String page;

    /**
     * The zoom.
     * 
     */
    @SerializedName(value = "zoom", alternate = {"Zoom"})
    @Expose
	@Nullable
    public Double zoom;


    /**
     * Instiaciates a new DriveItemPreviewParameterSet
     */
    public DriveItemPreviewParameterSet() {}
    /**
     * Instiaciates a new DriveItemPreviewParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected DriveItemPreviewParameterSet(@Nonnull final DriveItemPreviewParameterSetBuilder builder) {
        this.page = builder.page;
        this.zoom = builder.zoom;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static DriveItemPreviewParameterSetBuilder newBuilder() {
        return new DriveItemPreviewParameterSetBuilder();
    }
    /**
     * Fluent builder for the DriveItemPreviewParameterSet
     */
    public static final class DriveItemPreviewParameterSetBuilder {
        /**
         * The page parameter value
         */
        @Nullable
        protected String page;
        /**
         * Sets the Page
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public DriveItemPreviewParameterSetBuilder withPage(@Nullable final String val) {
            this.page = val;
            return this;
        }
        /**
         * The zoom parameter value
         */
        @Nullable
        protected Double zoom;
        /**
         * Sets the Zoom
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public DriveItemPreviewParameterSetBuilder withZoom(@Nullable final Double val) {
            this.zoom = val;
            return this;
        }
        /**
         * Instanciates a new DriveItemPreviewParameterSetBuilder
         */
        @Nullable
        protected DriveItemPreviewParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public DriveItemPreviewParameterSet build() {
            return new DriveItemPreviewParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.page != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("page", page));
        }
        if(this.zoom != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("zoom", zoom));
        }
        return result;
    }
}
