// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Chat Message Set Reaction Parameter Set.
 */
public class ChatMessageSetReactionParameterSet {
    /**
     * The reaction Type.
     * 
     */
    @SerializedName(value = "reactionType", alternate = {"ReactionType"})
    @Expose
	@Nullable
    public String reactionType;


    /**
     * Instiaciates a new ChatMessageSetReactionParameterSet
     */
    public ChatMessageSetReactionParameterSet() {}
    /**
     * Instiaciates a new ChatMessageSetReactionParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected ChatMessageSetReactionParameterSet(@Nonnull final ChatMessageSetReactionParameterSetBuilder builder) {
        this.reactionType = builder.reactionType;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static ChatMessageSetReactionParameterSetBuilder newBuilder() {
        return new ChatMessageSetReactionParameterSetBuilder();
    }
    /**
     * Fluent builder for the ChatMessageSetReactionParameterSet
     */
    public static final class ChatMessageSetReactionParameterSetBuilder {
        /**
         * The reactionType parameter value
         */
        @Nullable
        protected String reactionType;
        /**
         * Sets the ReactionType
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ChatMessageSetReactionParameterSetBuilder withReactionType(@Nullable final String val) {
            this.reactionType = val;
            return this;
        }
        /**
         * Instanciates a new ChatMessageSetReactionParameterSetBuilder
         */
        @Nullable
        protected ChatMessageSetReactionParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public ChatMessageSetReactionParameterSet build() {
            return new ChatMessageSetReactionParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.reactionType != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("reactionType", reactionType));
        }
        return result;
    }
}
