// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.CallRecordingStatus;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.EventMessageDetail;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Call Recording Event Message Detail.
 */
public class CallRecordingEventMessageDetail extends EventMessageDetail implements IJsonBackedObject {


    /**
     * The Call Id.
     * Unique identifier of the call.
     */
    @SerializedName(value = "callId", alternate = {"CallId"})
    @Expose
	@Nullable
    public String callId;

    /**
     * The Call Recording Display Name.
     * Display name for the call recording.
     */
    @SerializedName(value = "callRecordingDisplayName", alternate = {"CallRecordingDisplayName"})
    @Expose
	@Nullable
    public String callRecordingDisplayName;

    /**
     * The Call Recording Duration.
     * Duration of the call recording.
     */
    @SerializedName(value = "callRecordingDuration", alternate = {"CallRecordingDuration"})
    @Expose
	@Nullable
    public javax.xml.datatype.Duration callRecordingDuration;

    /**
     * The Call Recording Status.
     * Status of the call recording. Possible values are: success, failure, initial, chunkFinished, unknownFutureValue.
     */
    @SerializedName(value = "callRecordingStatus", alternate = {"CallRecordingStatus"})
    @Expose
	@Nullable
    public CallRecordingStatus callRecordingStatus;

    /**
     * The Call Recording Url.
     * Call recording URL.
     */
    @SerializedName(value = "callRecordingUrl", alternate = {"CallRecordingUrl"})
    @Expose
	@Nullable
    public String callRecordingUrl;

    /**
     * The Initiator.
     * Initiator of the event.
     */
    @SerializedName(value = "initiator", alternate = {"Initiator"})
    @Expose
	@Nullable
    public IdentitySet initiator;

    /**
     * The Meeting Organizer.
     * Organizer of the meeting.
     */
    @SerializedName(value = "meetingOrganizer", alternate = {"MeetingOrganizer"})
    @Expose
	@Nullable
    public IdentitySet meetingOrganizer;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
