// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.BrowserSharedCookieHistory;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.BrowserSharedCookieSourceEnvironment;
import com.microsoft.graph.models.BrowserSharedCookieStatus;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Browser Shared Cookie.
 */
public class BrowserSharedCookie extends Entity implements IJsonBackedObject {


    /**
     * The Comment.
     * The comment for the shared cookie.
     */
    @SerializedName(value = "comment", alternate = {"Comment"})
    @Expose
	@Nullable
    public String comment;

    /**
     * The Created Date Time.
     * The date and time when the shared cookie was created.
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdDateTime;

    /**
     * The Deleted Date Time.
     * The date and time when the shared cookie was deleted.
     */
    @SerializedName(value = "deletedDateTime", alternate = {"DeletedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime deletedDateTime;

    /**
     * The Display Name.
     * The name of the cookie.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The History.
     * The history of modifications applied to the cookie.
     */
    @SerializedName(value = "history", alternate = {"History"})
    @Expose
	@Nullable
    public java.util.List<BrowserSharedCookieHistory> history;

    /**
     * The Host Only.
     * Controls whether a cookie is a host-only or domain cookie.
     */
    @SerializedName(value = "hostOnly", alternate = {"HostOnly"})
    @Expose
	@Nullable
    public Boolean hostOnly;

    /**
     * The Host Or Domain.
     * The URL of the cookie.
     */
    @SerializedName(value = "hostOrDomain", alternate = {"HostOrDomain"})
    @Expose
	@Nullable
    public String hostOrDomain;

    /**
     * The Last Modified By.
     * The user who last modified the cookie.
     */
    @SerializedName(value = "lastModifiedBy", alternate = {"LastModifiedBy"})
    @Expose
	@Nullable
    public IdentitySet lastModifiedBy;

    /**
     * The Last Modified Date Time.
     * The date and time when the cookie was last modified.
     */
    @SerializedName(value = "lastModifiedDateTime", alternate = {"LastModifiedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastModifiedDateTime;

    /**
     * The Path.
     * The path of the cookie.
     */
    @SerializedName(value = "path", alternate = {"Path"})
    @Expose
	@Nullable
    public String path;

    /**
     * The Source Environment.
     * Specifies how the cookies are shared between Microsoft Edge and Internet Explorer. The possible values are: microsoftEdge, internetExplorer11, both, unknownFutureValue.
     */
    @SerializedName(value = "sourceEnvironment", alternate = {"SourceEnvironment"})
    @Expose
	@Nullable
    public BrowserSharedCookieSourceEnvironment sourceEnvironment;

    /**
     * The Status.
     * The status of the cookie. The possible values are: published, pendingAdd, pendingEdit, pendingDelete, unknownFutureValue.
     */
    @SerializedName(value = "status", alternate = {"Status"})
    @Expose
	@Nullable
    public BrowserSharedCookieStatus status;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
