// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.AuthenticationMethodModes;
import com.microsoft.graph.models.UpdateAllowedCombinationsResult;
import java.util.EnumSet;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Authentication Strength Policy Update Allowed Combinations Parameter Set.
 */
public class AuthenticationStrengthPolicyUpdateAllowedCombinationsParameterSet {
    /**
     * The allowed Combinations.
     * 
     */
    @SerializedName(value = "allowedCombinations", alternate = {"AllowedCombinations"})
    @Expose
	@Nullable
    public java.util.List<EnumSet<AuthenticationMethodModes>> allowedCombinations;


    /**
     * Instiaciates a new AuthenticationStrengthPolicyUpdateAllowedCombinationsParameterSet
     */
    public AuthenticationStrengthPolicyUpdateAllowedCombinationsParameterSet() {}
    /**
     * Instiaciates a new AuthenticationStrengthPolicyUpdateAllowedCombinationsParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected AuthenticationStrengthPolicyUpdateAllowedCombinationsParameterSet(@Nonnull final AuthenticationStrengthPolicyUpdateAllowedCombinationsParameterSetBuilder builder) {
        this.allowedCombinations = builder.allowedCombinations;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static AuthenticationStrengthPolicyUpdateAllowedCombinationsParameterSetBuilder newBuilder() {
        return new AuthenticationStrengthPolicyUpdateAllowedCombinationsParameterSetBuilder();
    }
    /**
     * Fluent builder for the AuthenticationStrengthPolicyUpdateAllowedCombinationsParameterSet
     */
    public static final class AuthenticationStrengthPolicyUpdateAllowedCombinationsParameterSetBuilder {
        /**
         * The allowedCombinations parameter value
         */
        @Nullable
        protected java.util.List<EnumSet<AuthenticationMethodModes>> allowedCombinations;
        /**
         * Sets the AllowedCombinations
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public AuthenticationStrengthPolicyUpdateAllowedCombinationsParameterSetBuilder withAllowedCombinations(@Nullable final java.util.List<EnumSet<AuthenticationMethodModes>> val) {
            this.allowedCombinations = val;
            return this;
        }
        /**
         * Instanciates a new AuthenticationStrengthPolicyUpdateAllowedCombinationsParameterSetBuilder
         */
        @Nullable
        protected AuthenticationStrengthPolicyUpdateAllowedCombinationsParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public AuthenticationStrengthPolicyUpdateAllowedCombinationsParameterSet build() {
            return new AuthenticationStrengthPolicyUpdateAllowedCombinationsParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.allowedCombinations != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("allowedCombinations", allowedCombinations));
        }
        return result;
    }
}
