// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.Identity;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Approval Stage.
 */
public class ApprovalStage extends Entity implements IJsonBackedObject {


    /**
     * The Assigned To Me.
     * Indicates whether the stage is assigned to the calling user to review. Read-only.
     */
    @SerializedName(value = "assignedToMe", alternate = {"AssignedToMe"})
    @Expose
	@Nullable
    public Boolean assignedToMe;

    /**
     * The Display Name.
     * The label provided by the policy creator to identify an approval stage. Read-only.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Justification.
     * The justification associated with the approval stage decision.
     */
    @SerializedName(value = "justification", alternate = {"Justification"})
    @Expose
	@Nullable
    public String justification;

    /**
     * The Reviewed By.
     * The identifier of the reviewer. 00000000-0000-0000-0000-000000000000 if the assigned reviewer hasn't reviewed. Read-only.
     */
    @SerializedName(value = "reviewedBy", alternate = {"ReviewedBy"})
    @Expose
	@Nullable
    public Identity reviewedBy;

    /**
     * The Reviewed Date Time.
     * The date and time when a decision was recorded. The date and time information uses ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z. Read-only.
     */
    @SerializedName(value = "reviewedDateTime", alternate = {"ReviewedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime reviewedDateTime;

    /**
     * The Review Result.
     * The result of this approval record. Possible values include: NotReviewed, Approved, Denied.
     */
    @SerializedName(value = "reviewResult", alternate = {"ReviewResult"})
    @Expose
	@Nullable
    public String reviewResult;

    /**
     * The Status.
     * The stage status. Possible values: InProgress, Initializing, Completed, Expired. Read-only.
     */
    @SerializedName(value = "status", alternate = {"Status"})
    @Expose
	@Nullable
    public String status;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
