// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Application Set Verified Publisher Parameter Set.
 */
public class ApplicationSetVerifiedPublisherParameterSet {
    /**
     * The verified Publisher Id.
     * 
     */
    @SerializedName(value = "verifiedPublisherId", alternate = {"VerifiedPublisherId"})
    @Expose
	@Nullable
    public String verifiedPublisherId;


    /**
     * Instiaciates a new ApplicationSetVerifiedPublisherParameterSet
     */
    public ApplicationSetVerifiedPublisherParameterSet() {}
    /**
     * Instiaciates a new ApplicationSetVerifiedPublisherParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected ApplicationSetVerifiedPublisherParameterSet(@Nonnull final ApplicationSetVerifiedPublisherParameterSetBuilder builder) {
        this.verifiedPublisherId = builder.verifiedPublisherId;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static ApplicationSetVerifiedPublisherParameterSetBuilder newBuilder() {
        return new ApplicationSetVerifiedPublisherParameterSetBuilder();
    }
    /**
     * Fluent builder for the ApplicationSetVerifiedPublisherParameterSet
     */
    public static final class ApplicationSetVerifiedPublisherParameterSetBuilder {
        /**
         * The verifiedPublisherId parameter value
         */
        @Nullable
        protected String verifiedPublisherId;
        /**
         * Sets the VerifiedPublisherId
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ApplicationSetVerifiedPublisherParameterSetBuilder withVerifiedPublisherId(@Nullable final String val) {
            this.verifiedPublisherId = val;
            return this;
        }
        /**
         * Instanciates a new ApplicationSetVerifiedPublisherParameterSetBuilder
         */
        @Nullable
        protected ApplicationSetVerifiedPublisherParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public ApplicationSetVerifiedPublisherParameterSet build() {
            return new ApplicationSetVerifiedPublisherParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.verifiedPublisherId != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("verifiedPublisherId", verifiedPublisherId));
        }
        return result;
    }
}
