// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.identitygovernance.models.WorkflowVersion;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workflow Version Request.
 */
public class WorkflowVersionRequest extends BaseRequest<WorkflowVersion> {
	
    /**
     * The request for the WorkflowVersion
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkflowVersionRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkflowVersion.class);
    }

    /**
     * Gets the WorkflowVersion from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkflowVersion> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the WorkflowVersion from the service
     *
     * @return the WorkflowVersion from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkflowVersion get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkflowVersion> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public WorkflowVersion delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WorkflowVersion with a source
     *
     * @param sourceWorkflowVersion the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkflowVersion> patchAsync(@Nonnull final WorkflowVersion sourceWorkflowVersion) {
        return sendAsync(HttpMethod.PATCH, sourceWorkflowVersion);
    }

    /**
     * Patches this WorkflowVersion with a source
     *
     * @param sourceWorkflowVersion the source object with updates
     * @return the updated WorkflowVersion
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkflowVersion patch(@Nonnull final WorkflowVersion sourceWorkflowVersion) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkflowVersion);
    }

    /**
     * Creates a WorkflowVersion with a new object
     *
     * @param newWorkflowVersion the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkflowVersion> postAsync(@Nonnull final WorkflowVersion newWorkflowVersion) {
        return sendAsync(HttpMethod.POST, newWorkflowVersion);
    }

    /**
     * Creates a WorkflowVersion with a new object
     *
     * @param newWorkflowVersion the new object to create
     * @return the created WorkflowVersion
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkflowVersion post(@Nonnull final WorkflowVersion newWorkflowVersion) throws ClientException {
        return send(HttpMethod.POST, newWorkflowVersion);
    }

    /**
     * Creates a WorkflowVersion with a new object
     *
     * @param newWorkflowVersion the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkflowVersion> putAsync(@Nonnull final WorkflowVersion newWorkflowVersion) {
        return sendAsync(HttpMethod.PUT, newWorkflowVersion);
    }

    /**
     * Creates a WorkflowVersion with a new object
     *
     * @param newWorkflowVersion the object to create/update
     * @return the created WorkflowVersion
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkflowVersion put(@Nonnull final WorkflowVersion newWorkflowVersion) throws ClientException {
        return send(HttpMethod.PUT, newWorkflowVersion);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WorkflowVersionRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WorkflowVersionRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

