// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.identitygovernance.models.TaskReport;
import com.microsoft.graph.identitygovernance.models.TaskReportSummary;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Task Report Request Builder.
 */
public class TaskReportRequestBuilder extends BaseRequestBuilder<TaskReport> {

    /**
     * The request builder for the TaskReport
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TaskReportRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the TaskReportRequest instance
     */
    @Nonnull
    public TaskReportRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the TaskReportRequest instance
     */
    @Nonnull
    public TaskReportRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.identitygovernance.requests.TaskReportRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for Task
     *
     * @return the TaskWithReferenceRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.identitygovernance.requests.TaskWithReferenceRequestBuilder task() {
        return new com.microsoft.graph.identitygovernance.requests.TaskWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("task"), getClient(), null);
    }

    /**
     * Gets the request builder for TaskDefinition
     *
     * @return the TaskDefinitionWithReferenceRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.identitygovernance.requests.TaskDefinitionWithReferenceRequestBuilder taskDefinition() {
        return new com.microsoft.graph.identitygovernance.requests.TaskDefinitionWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("taskDefinition"), getClient(), null);
    }
    /**
     *  Gets a request builder for the TaskProcessingResult collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.identitygovernance.requests.TaskProcessingResultCollectionRequestBuilder taskProcessingResults() {
        return new com.microsoft.graph.identitygovernance.requests.TaskProcessingResultCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("taskProcessingResults"), getClient(), null);
    }

    /**
     * Gets a request builder for the TaskProcessingResult item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.identitygovernance.requests.TaskProcessingResultRequestBuilder taskProcessingResults(@Nonnull final String id) {
        return new com.microsoft.graph.identitygovernance.requests.TaskProcessingResultRequestBuilder(getRequestUrlWithAdditionalSegment("taskProcessingResults") + "/" + id, getClient(), null);
    }
}
