// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.identitygovernance.models.LifecycleWorkflowCategory;
import com.microsoft.graph.identitygovernance.models.WorkflowExecutionConditions;
import com.microsoft.graph.models.User;
import com.microsoft.graph.identitygovernance.requests.TaskCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workflow Base.
 */
public class WorkflowBase implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Category.
     * The category of the workflow. The possible values are: joiner, leaver, unknownFutureValue.
     */
    @SerializedName(value = "category", alternate = {"Category"})
    @Expose
	@Nullable
    public LifecycleWorkflowCategory category;

    /**
     * The Created Date Time.
     * When a workflow was created.
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdDateTime;

    /**
     * The Description.
     * A string that describes the purpose of the workflow.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Display Name.
     * A string to identify the workflow.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Execution Conditions.
     * Defines when and for who the workflow will run.
     */
    @SerializedName(value = "executionConditions", alternate = {"ExecutionConditions"})
    @Expose
	@Nullable
    public WorkflowExecutionConditions executionConditions;

    /**
     * The Is Enabled.
     * Whether the workflow is enabled or disabled. If this setting is true, the workflow can be run on demand or on schedule when isSchedulingEnabled is true.
     */
    @SerializedName(value = "isEnabled", alternate = {"IsEnabled"})
    @Expose
	@Nullable
    public Boolean isEnabled;

    /**
     * The Is Scheduling Enabled.
     * If true, the Lifecycle Workflow engine executes the workflow based on the schedule defined by tenant settings. Cannot be true for a disabled workflow (where isEnabled is false).
     */
    @SerializedName(value = "isSchedulingEnabled", alternate = {"IsSchedulingEnabled"})
    @Expose
	@Nullable
    public Boolean isSchedulingEnabled;

    /**
     * The Last Modified Date Time.
     * When the workflow was last modified.
     */
    @SerializedName(value = "lastModifiedDateTime", alternate = {"LastModifiedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastModifiedDateTime;

    /**
     * The Created By.
     * The user who created the workflow.
     */
    @SerializedName(value = "createdBy", alternate = {"CreatedBy"})
    @Expose
	@Nullable
    public User createdBy;

    /**
     * The Last Modified By.
     * The unique identifier of the AAD identity that last modified the workflow.
     */
    @SerializedName(value = "lastModifiedBy", alternate = {"LastModifiedBy"})
    @Expose
	@Nullable
    public User lastModifiedBy;

    /**
     * The Tasks.
     * The tasks in the workflow.
     */
    @SerializedName(value = "tasks", alternate = {"Tasks"})
    @Expose
	@Nullable
    public com.microsoft.graph.identitygovernance.requests.TaskCollectionPage tasks;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("tasks")) {
            tasks = serializer.deserializeObject(json.get("tasks"), com.microsoft.graph.identitygovernance.requests.TaskCollectionPage.class);
        }
    }
}
