/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.ediscovery.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.ediscovery.models.ReviewSet;
import com.microsoft.graph.ediscovery.requests.ReviewSetCollectionPage;
import com.microsoft.graph.ediscovery.requests.ReviewSetCollectionRequestBuilder;
import com.microsoft.graph.ediscovery.requests.ReviewSetCollectionResponse;
import com.microsoft.graph.ediscovery.requests.ReviewSetRequestBuilder;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReviewSetCollectionRequest
extends BaseEntityCollectionRequest<ReviewSet, ReviewSetCollectionResponse, ReviewSetCollectionPage> {
    public ReviewSetCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ReviewSetCollectionResponse.class, ReviewSetCollectionPage.class, ReviewSetCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<ReviewSet> postAsync(@Nonnull ReviewSet newReviewSet) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ReviewSetRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newReviewSet);
    }

    @Nonnull
    public ReviewSet post(@Nonnull ReviewSet newReviewSet) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ReviewSetRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newReviewSet);
    }

    @Nonnull
    public ReviewSetCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public ReviewSetCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public ReviewSetCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public ReviewSetCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ReviewSetCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public ReviewSetCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public ReviewSetCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public ReviewSetCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public ReviewSetCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

