/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.requests;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseReferenceRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.security.models.Article;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ArticleReferenceRequest
extends BaseReferenceRequest<Article> {
    public ArticleReferenceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Article.class);
    }

    @Nonnull
    public ArticleReferenceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ArticleReferenceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public CompletableFuture<Article> putAsync(@Nonnull Article srcArticle) {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/security/threatIntelligence/{id}/articles/" + srcArticle.id));
        return this.sendAsync(HttpMethod.PUT, payload);
    }

    @Nullable
    public Article put(@Nonnull Article srcArticle) throws ClientException {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/security/threatIntelligence/{id}/articles/" + srcArticle.id));
        return (Article)this.send(HttpMethod.PUT, payload);
    }
}

