/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.requests;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseReferenceRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.security.models.HostCookie;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HostCookieReferenceRequest
extends BaseReferenceRequest<HostCookie> {
    public HostCookieReferenceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, HostCookie.class);
    }

    @Nonnull
    public HostCookieReferenceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public HostCookieReferenceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public CompletableFuture<HostCookie> putAsync(@Nonnull HostCookie srcHostCookie) {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/security/threatIntelligence/{id}/hostCookies/" + srcHostCookie.id));
        return this.sendAsync(HttpMethod.PUT, payload);
    }

    @Nullable
    public HostCookie put(@Nonnull HostCookie srcHostCookie) throws ClientException {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/security/threatIntelligence/{id}/hostCookies/" + srcHostCookie.id));
        return (HostCookie)this.send(HttpMethod.PUT, payload);
    }
}

