// Template Source: BaseEntityCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.EdiscoveryCase;
import com.microsoft.graph.security.models.EdiscoveryCustodian;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.security.requests.EdiscoveryCustodianCollectionRequestBuilder;
import com.microsoft.graph.security.requests.EdiscoveryCustodianRequestBuilder;
import com.microsoft.graph.security.requests.EdiscoveryCustodianCollectionRequest;
import com.microsoft.graph.security.requests.EdiscoveryCustodianApplyHoldRequestBuilder;
import com.microsoft.graph.security.requests.EdiscoveryCustodianRemoveHoldRequestBuilder;
import com.microsoft.graph.http.BaseCollectionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.PrimitiveRequestBuilder;
import com.microsoft.graph.security.models.EdiscoveryCustodianApplyHoldParameterSet;
import com.microsoft.graph.security.models.EdiscoveryCustodianRemoveHoldParameterSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Custodian Collection Request Builder.
 */
public class EdiscoveryCustodianCollectionRequestBuilder extends BaseCollectionRequestBuilder<EdiscoveryCustodian, EdiscoveryCustodianRequestBuilder, EdiscoveryCustodianCollectionResponse, EdiscoveryCustodianCollectionPage, EdiscoveryCustodianCollectionRequest> {

    /**
     * The request builder for this collection of EdiscoveryCase
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EdiscoveryCustodianCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EdiscoveryCustodianRequestBuilder.class, EdiscoveryCustodianCollectionRequest.class);
    }



    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public EdiscoveryCustodianApplyHoldRequestBuilder applyHold(@Nonnull final EdiscoveryCustodianApplyHoldParameterSet parameters) {
        return new EdiscoveryCustodianApplyHoldRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.security.applyHold"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public EdiscoveryCustodianRemoveHoldRequestBuilder removeHold(@Nonnull final EdiscoveryCustodianRemoveHoldParameterSet parameters) {
        return new EdiscoveryCustodianRemoveHoldRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.security.removeHold"), getClient(), null, parameters);
    }

    /**
     * Gets the raw count request for the collection
     * @return The raw count request for the collection
     */
    @Nonnull
    public PrimitiveRequestBuilder<Long> count() {
        return new PrimitiveRequestBuilder<Long>(getRequestUrlWithAdditionalSegment("$count"), getClient(), null, Long.class);
    }
}
