// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.LoginPageLayoutConfiguration;
import com.microsoft.graph.models.LoginPageTextVisibilitySettings;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Organizational Branding Properties.
 */
public class OrganizationalBrandingProperties extends Entity implements IJsonBackedObject {


    /**
     * The Background Color.
     * Color that will appear in place of the background image in low-bandwidth connections. We recommend that you use the primary color of your banner logo or your organization color. Specify this in hexadecimal format, for example, white is #FFFFFF.
     */
    @SerializedName(value = "backgroundColor", alternate = {"BackgroundColor"})
    @Expose
	@Nullable
    public String backgroundColor;

    /**
     * The Background Image Relative Url.
     * A relative URL for the backgroundImage property that is combined with a CDN base URL from the cdnList to provide the version served by a CDN. Read-only.
     */
    @SerializedName(value = "backgroundImageRelativeUrl", alternate = {"BackgroundImageRelativeUrl"})
    @Expose
	@Nullable
    public String backgroundImageRelativeUrl;

    /**
     * The Banner Logo Relative Url.
     * A relative url for the bannerLogo property that is combined with a CDN base URL from the cdnList to provide the read-only version served by a CDN. Read-only.
     */
    @SerializedName(value = "bannerLogoRelativeUrl", alternate = {"BannerLogoRelativeUrl"})
    @Expose
	@Nullable
    public String bannerLogoRelativeUrl;

    /**
     * The Cdn List.
     * A list of base URLs for all available CDN providers that are serving the assets of the current resource. Several CDN providers are used at the same time for high availability of read requests. Read-only.
     */
    @SerializedName(value = "cdnList", alternate = {"CdnList"})
    @Expose
	@Nullable
    public java.util.List<String> cdnList;

    /**
     * The Custom Account Reset Credentials Url.
     * 
     */
    @SerializedName(value = "customAccountResetCredentialsUrl", alternate = {"CustomAccountResetCredentialsUrl"})
    @Expose
	@Nullable
    public String customAccountResetCredentialsUrl;

    /**
     * The Custom Cannot Access Your Account Text.
     * 
     */
    @SerializedName(value = "customCannotAccessYourAccountText", alternate = {"CustomCannotAccessYourAccountText"})
    @Expose
	@Nullable
    public String customCannotAccessYourAccountText;

    /**
     * The Custom Cannot Access Your Account Url.
     * 
     */
    @SerializedName(value = "customCannotAccessYourAccountUrl", alternate = {"CustomCannotAccessYourAccountUrl"})
    @Expose
	@Nullable
    public String customCannotAccessYourAccountUrl;

    /**
     * The Custom CSSRelative Url.
     * 
     */
    @SerializedName(value = "customCSSRelativeUrl", alternate = {"CustomCSSRelativeUrl"})
    @Expose
	@Nullable
    public String customCSSRelativeUrl;

    /**
     * The Custom Forgot My Password Text.
     * 
     */
    @SerializedName(value = "customForgotMyPasswordText", alternate = {"CustomForgotMyPasswordText"})
    @Expose
	@Nullable
    public String customForgotMyPasswordText;

    /**
     * The Custom Privacy And Cookies Text.
     * 
     */
    @SerializedName(value = "customPrivacyAndCookiesText", alternate = {"CustomPrivacyAndCookiesText"})
    @Expose
	@Nullable
    public String customPrivacyAndCookiesText;

    /**
     * The Custom Privacy And Cookies Url.
     * 
     */
    @SerializedName(value = "customPrivacyAndCookiesUrl", alternate = {"CustomPrivacyAndCookiesUrl"})
    @Expose
	@Nullable
    public String customPrivacyAndCookiesUrl;

    /**
     * The Custom Reset It Now Text.
     * 
     */
    @SerializedName(value = "customResetItNowText", alternate = {"CustomResetItNowText"})
    @Expose
	@Nullable
    public String customResetItNowText;

    /**
     * The Custom Terms Of Use Text.
     * 
     */
    @SerializedName(value = "customTermsOfUseText", alternate = {"CustomTermsOfUseText"})
    @Expose
	@Nullable
    public String customTermsOfUseText;

    /**
     * The Custom Terms Of Use Url.
     * 
     */
    @SerializedName(value = "customTermsOfUseUrl", alternate = {"CustomTermsOfUseUrl"})
    @Expose
	@Nullable
    public String customTermsOfUseUrl;

    /**
     * The Favicon Relative Url.
     * 
     */
    @SerializedName(value = "faviconRelativeUrl", alternate = {"FaviconRelativeUrl"})
    @Expose
	@Nullable
    public String faviconRelativeUrl;

    /**
     * The Header Background Color.
     * 
     */
    @SerializedName(value = "headerBackgroundColor", alternate = {"HeaderBackgroundColor"})
    @Expose
	@Nullable
    public String headerBackgroundColor;

    /**
     * The Header Logo Relative Url.
     * 
     */
    @SerializedName(value = "headerLogoRelativeUrl", alternate = {"HeaderLogoRelativeUrl"})
    @Expose
	@Nullable
    public String headerLogoRelativeUrl;

    /**
     * The Login Page Layout Configuration.
     * 
     */
    @SerializedName(value = "loginPageLayoutConfiguration", alternate = {"LoginPageLayoutConfiguration"})
    @Expose
	@Nullable
    public LoginPageLayoutConfiguration loginPageLayoutConfiguration;

    /**
     * The Login Page Text Visibility Settings.
     * 
     */
    @SerializedName(value = "loginPageTextVisibilitySettings", alternate = {"LoginPageTextVisibilitySettings"})
    @Expose
	@Nullable
    public LoginPageTextVisibilitySettings loginPageTextVisibilitySettings;

    /**
     * The Sign In Page Text.
     * Text that appears at the bottom of the sign-in box. You can use this to communicate additional information, such as the phone number to your help desk or a legal statement. This text must be Unicode and not exceed 1024 characters.
     */
    @SerializedName(value = "signInPageText", alternate = {"SignInPageText"})
    @Expose
	@Nullable
    public String signInPageText;

    /**
     * The Square Logo Dark Relative Url.
     * 
     */
    @SerializedName(value = "squareLogoDarkRelativeUrl", alternate = {"SquareLogoDarkRelativeUrl"})
    @Expose
	@Nullable
    public String squareLogoDarkRelativeUrl;

    /**
     * The Square Logo Relative Url.
     * A relative url for the squareLogo property that is combined with a CDN base URL from the cdnList to provide the version served by a CDN. Read-only.
     */
    @SerializedName(value = "squareLogoRelativeUrl", alternate = {"SquareLogoRelativeUrl"})
    @Expose
	@Nullable
    public String squareLogoRelativeUrl;

    /**
     * The Username Hint Text.
     * String that shows as the hint in the username textbox on the sign-in screen. This text must be a Unicode, without links or code, and can't exceed 64 characters.
     */
    @SerializedName(value = "usernameHintText", alternate = {"UsernameHintText"})
    @Expose
	@Nullable
    public String usernameHintText;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
