// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.AccessPackageExternalUserLifecycleAction;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Entitlement Management Settings.
 */
public class EntitlementManagementSettings extends Entity implements IJsonBackedObject {


    /**
     * The Duration Until External User Deleted After Blocked.
     * If externalUserLifecycleAction is blockSignInAndDelete, the duration, typically a number of days, after an external user is blocked from sign in before their account is deleted.
     */
    @SerializedName(value = "durationUntilExternalUserDeletedAfterBlocked", alternate = {"DurationUntilExternalUserDeletedAfterBlocked"})
    @Expose
	@Nullable
    public javax.xml.datatype.Duration durationUntilExternalUserDeletedAfterBlocked;

    /**
     * The External User Lifecycle Action.
     * Automatic action that the service should take when an external user's last access package assignment is removed. The possible values are: none, blockSignIn, blockSignInAndDelete, unknownFutureValue.
     */
    @SerializedName(value = "externalUserLifecycleAction", alternate = {"ExternalUserLifecycleAction"})
    @Expose
	@Nullable
    public AccessPackageExternalUserLifecycleAction externalUserLifecycleAction;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
