// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.externalconnectors.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.externalconnectors.models.ExternalActivityResult;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the External Activity Result Request.
 */
public class ExternalActivityResultRequest extends BaseRequest<ExternalActivityResult> {
	
    /**
     * The request for the ExternalActivityResult
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ExternalActivityResultRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ExternalActivityResult.class);
    }

    /**
     * Gets the ExternalActivityResult from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ExternalActivityResult> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ExternalActivityResult from the service
     *
     * @return the ExternalActivityResult from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ExternalActivityResult get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ExternalActivityResult> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ExternalActivityResult delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ExternalActivityResult with a source
     *
     * @param sourceExternalActivityResult the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ExternalActivityResult> patchAsync(@Nonnull final ExternalActivityResult sourceExternalActivityResult) {
        return sendAsync(HttpMethod.PATCH, sourceExternalActivityResult);
    }

    /**
     * Patches this ExternalActivityResult with a source
     *
     * @param sourceExternalActivityResult the source object with updates
     * @return the updated ExternalActivityResult
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ExternalActivityResult patch(@Nonnull final ExternalActivityResult sourceExternalActivityResult) throws ClientException {
        return send(HttpMethod.PATCH, sourceExternalActivityResult);
    }

    /**
     * Creates a ExternalActivityResult with a new object
     *
     * @param newExternalActivityResult the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ExternalActivityResult> postAsync(@Nonnull final ExternalActivityResult newExternalActivityResult) {
        return sendAsync(HttpMethod.POST, newExternalActivityResult);
    }

    /**
     * Creates a ExternalActivityResult with a new object
     *
     * @param newExternalActivityResult the new object to create
     * @return the created ExternalActivityResult
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ExternalActivityResult post(@Nonnull final ExternalActivityResult newExternalActivityResult) throws ClientException {
        return send(HttpMethod.POST, newExternalActivityResult);
    }

    /**
     * Creates a ExternalActivityResult with a new object
     *
     * @param newExternalActivityResult the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ExternalActivityResult> putAsync(@Nonnull final ExternalActivityResult newExternalActivityResult) {
        return sendAsync(HttpMethod.PUT, newExternalActivityResult);
    }

    /**
     * Creates a ExternalActivityResult with a new object
     *
     * @param newExternalActivityResult the object to create/update
     * @return the created ExternalActivityResult
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ExternalActivityResult put(@Nonnull final ExternalActivityResult newExternalActivityResult) throws ClientException {
        return send(HttpMethod.PUT, newExternalActivityResult);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ExternalActivityResultRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ExternalActivityResultRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

