/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.ediscovery.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.ediscovery.models.Tag;
import com.microsoft.graph.ediscovery.requests.TagCollectionPage;
import com.microsoft.graph.ediscovery.requests.TagCollectionRequestBuilder;
import com.microsoft.graph.ediscovery.requests.TagCollectionResponse;
import com.microsoft.graph.ediscovery.requests.TagRequestBuilder;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TagCollectionRequest
extends BaseEntityCollectionRequest<Tag, TagCollectionResponse, TagCollectionPage> {
    public TagCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TagCollectionResponse.class, TagCollectionPage.class, TagCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Tag> postAsync(@Nonnull Tag newTag) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TagRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newTag);
    }

    @Nonnull
    public Tag post(@Nonnull Tag newTag) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TagRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newTag);
    }

    @Nonnull
    public TagCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public TagCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public TagCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public TagCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public TagCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public TagCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public TagCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public TagCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public TagCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

