/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.ediscovery.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.ediscovery.models.SourceCollection;
import com.microsoft.graph.ediscovery.requests.SourceCollectionCollectionPage;
import com.microsoft.graph.ediscovery.requests.SourceCollectionCollectionRequestBuilder;
import com.microsoft.graph.ediscovery.requests.SourceCollectionCollectionResponse;
import com.microsoft.graph.ediscovery.requests.SourceCollectionRequestBuilder;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SourceCollectionCollectionRequest
extends BaseEntityCollectionRequest<SourceCollection, SourceCollectionCollectionResponse, SourceCollectionCollectionPage> {
    public SourceCollectionCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SourceCollectionCollectionResponse.class, SourceCollectionCollectionPage.class, SourceCollectionCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<SourceCollection> postAsync(@Nonnull SourceCollection newSourceCollection) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SourceCollectionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newSourceCollection);
    }

    @Nonnull
    public SourceCollection post(@Nonnull SourceCollection newSourceCollection) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SourceCollectionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSourceCollection);
    }

    @Nonnull
    public SourceCollectionCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public SourceCollectionCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public SourceCollectionCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public SourceCollectionCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public SourceCollectionCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public SourceCollectionCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public SourceCollectionCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public SourceCollectionCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public SourceCollectionCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

