/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.ediscovery.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.ediscovery.models.SiteSource;
import com.microsoft.graph.ediscovery.requests.SiteSourceCollectionPage;
import com.microsoft.graph.ediscovery.requests.SiteSourceCollectionRequestBuilder;
import com.microsoft.graph.ediscovery.requests.SiteSourceCollectionResponse;
import com.microsoft.graph.ediscovery.requests.SiteSourceRequestBuilder;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SiteSourceCollectionRequest
extends BaseEntityCollectionRequest<SiteSource, SiteSourceCollectionResponse, SiteSourceCollectionPage> {
    public SiteSourceCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SiteSourceCollectionResponse.class, SiteSourceCollectionPage.class, SiteSourceCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<SiteSource> postAsync(@Nonnull SiteSource newSiteSource) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SiteSourceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newSiteSource);
    }

    @Nonnull
    public SiteSource post(@Nonnull SiteSource newSiteSource) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SiteSourceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSiteSource);
    }

    @Nonnull
    public SiteSourceCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public SiteSourceCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public SiteSourceCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public SiteSourceCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public SiteSourceCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public SiteSourceCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public SiteSourceCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public SiteSourceCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public SiteSourceCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

