// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.ServiceHealthClassificationType;
import com.microsoft.graph.models.ServiceHealthOrigin;
import com.microsoft.graph.models.ServiceHealthIssuePost;
import com.microsoft.graph.models.ServiceHealthStatus;
import com.microsoft.graph.models.ServiceAnnouncementBase;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Service Health Issue.
 */
public class ServiceHealthIssue extends ServiceAnnouncementBase implements IJsonBackedObject {


    /**
     * The Classification.
     * The type of service health issue. Possible values are: advisory, incident, unknownFutureValue.
     */
    @SerializedName(value = "classification", alternate = {"Classification"})
    @Expose
	@Nullable
    public ServiceHealthClassificationType classification;

    /**
     * The Feature.
     * The feature name of the service issue.
     */
    @SerializedName(value = "feature", alternate = {"Feature"})
    @Expose
	@Nullable
    public String feature;

    /**
     * The Feature Group.
     * The feature group name of the service issue.
     */
    @SerializedName(value = "featureGroup", alternate = {"FeatureGroup"})
    @Expose
	@Nullable
    public String featureGroup;

    /**
     * The Impact Description.
     * The description of the service issue impact.
     */
    @SerializedName(value = "impactDescription", alternate = {"ImpactDescription"})
    @Expose
	@Nullable
    public String impactDescription;

    /**
     * The Is Resolved.
     * Indicates whether the issue is resolved.
     */
    @SerializedName(value = "isResolved", alternate = {"IsResolved"})
    @Expose
	@Nullable
    public Boolean isResolved;

    /**
     * The Origin.
     * Indicates the origin of the service issue. Possible values are: microsoft, thirdParty, customer, unknownFutureValue.
     */
    @SerializedName(value = "origin", alternate = {"Origin"})
    @Expose
	@Nullable
    public ServiceHealthOrigin origin;

    /**
     * The Posts.
     * Collection of historical posts for the service issue.
     */
    @SerializedName(value = "posts", alternate = {"Posts"})
    @Expose
	@Nullable
    public java.util.List<ServiceHealthIssuePost> posts;

    /**
     * The Service.
     * Indicates the service affected by the issue.
     */
    @SerializedName(value = "service", alternate = {"Service"})
    @Expose
	@Nullable
    public String service;

    /**
     * The Status.
     * The status of the service issue. Possible values are: serviceOperational, investigating, restoringService, verifyingService, serviceRestored, postIncidentReviewPublished, serviceDegradation, serviceInterruption, extendedRecovery, falsePositive, investigationSuspended, resolved, mitigatedExternal, mitigated, resolvedExternal, confirmed, reported, unknownFutureValue.
     */
    @SerializedName(value = "status", alternate = {"Status"})
    @Expose
	@Nullable
    public ServiceHealthStatus status;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
