// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.ediscovery.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.ediscovery.models.LegalHold;
import com.microsoft.graph.ediscovery.requests.SiteSourceCollectionRequestBuilder;
import com.microsoft.graph.ediscovery.requests.SiteSourceRequestBuilder;
import com.microsoft.graph.ediscovery.requests.UserSourceCollectionRequestBuilder;
import com.microsoft.graph.ediscovery.requests.UserSourceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Legal Hold Request Builder.
 */
public class LegalHoldRequestBuilder extends BaseRequestBuilder<LegalHold> {

    /**
     * The request builder for the LegalHold
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public LegalHoldRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the LegalHoldRequest instance
     */
    @Nonnull
    public LegalHoldRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the LegalHoldRequest instance
     */
    @Nonnull
    public LegalHoldRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.ediscovery.requests.LegalHoldRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the SiteSource collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public SiteSourceCollectionRequestBuilder siteSources() {
        return new SiteSourceCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("siteSources"), getClient(), null);
    }

    /**
     * Gets a request builder for the SiteSource item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public SiteSourceRequestBuilder siteSources(@Nonnull final String id) {
        return new SiteSourceRequestBuilder(getRequestUrlWithAdditionalSegment("siteSources") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the UserSource collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public UserSourceCollectionRequestBuilder userSources() {
        return new UserSourceCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("userSources"), getClient(), null);
    }

    /**
     * Gets a request builder for the UserSource item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public UserSourceRequestBuilder userSources(@Nonnull final String id) {
        return new UserSourceRequestBuilder(getRequestUrlWithAdditionalSegment("userSources") + "/" + id, getClient(), null);
    }
}
